<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Dashboard extends CI_Controller {

	// public function __construct()
    // {
    //     parent::__construct();

    //     $this->isLoggedIn();
    // }

    // public function isLoggedIn(){
    //     $is_logged_in = $this->session->userdata('logged_in');
    //     if(!isset($is_logged_in) || $is_logged_in!==TRUE)
    //     {
    //         redirect(base_url());
    //         exit;
    //     }
    // }
	public function header_and_footer($page, $data)
    {
        
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	public function index()
    {
        $data['title'] = 'Dashboard';
        $where = ['is_disable'=>0];$data['total_commision']=0;$data['total_payout']=0;
		if($this->session->userdata('usertype') == 'channel_partner'){
            $where = ['channel_partner_id'=>$this->session->userdata('id'),'is_disable'=>0];
        }
		$data['total_orders'] = $this->model->countData('orders',$where);
		$orderData = $this->model->getResultData('orders', $where);
        foreach($orderData as $order){
            $data['total_commision']+= (int)$order['commision'];
        }
        $payoutData = $this->model->getResultData('payout',$where);
        $total_payouts=0;
        foreach($payoutData as $payout){
            $data['total_payout']+= (int)$payout['amount'];
        }
		$data['total_channel_partner'] = $this->model->countData('channel_partner',['is_suspended'=>0]);
        $page = 'dashboard';
        $this->header_and_footer($page, $data);
    }
	public function logout(){
        if($this->session->userdata('usertype') == 'admin'){
            $redirect = 'admin';
        }else if($this->session->userdata('usertype') == 'channel_partner'){
            $redirect = 'channel-partner-login';
        }else if($this->session->userdata('usertype') == 'manager'){
            $redirect = 'manager-login';
        }
		$this->session->unset_userdata(array('logged_in','email','usertype','id'));
		redirect(base_url($redirect));
	}
	function multipleDel()
    {
		$this->multipleDelete();
    }
    function Status()
    {
		$this->changeStatus();
    }
    function changeLeaveStatus()
    {
		$this->changeLeaveStatus();
    }
    public function fetch_state()
    {
        if ($this->input->post('country_id')) {
            $cid = $this->input->post('country_id');
            $this->model->fetch_state($cid,$this->input->post('state_id'));
        }
    }
    public function fetch_city()
    {
        if ($this->input->post('state_id')) {
            $sid = $this->input->post('state_id');
            $this->model->fetch_city($sid,$this->input->post('city_id'));
        }
    }
    public function fetch_price()
    {
        if ($this->input->post('product_id')) {
            $productData = $this->model->fetch_price($this->input->post('product_id'));
            echo $productData['mrp'];
        }
    }
    public function fetch_unit()
    {
        if ($this->input->post('product_id')) {
            $productData = $this->model->getRowData('product',['id'=>$this->input->post('product_id')]);
            if(isset($productData['unit_id'])){
                $unitData = $this->model->getRowData('unit',['id'=>$productData['unit_id']]);
                echo '('.$unitData['name'].')';
            }else{
                echo '';
            }
            
        }
    }

    public function fetch_quotation()
    {
        if ($this->input->post('customer_id')) {
            $vid = $this->input->post('customer_id');
            $this->model->fetch_quotation($vid,$this->input->post('quotation_id'));
        }
    }
    public function punchIn()
    {
        $staff_id = $this->session->userdata('id');
        date_default_timezone_set('Asia/Kolkata');
        $data = array(
            'staff_id' => $staff_id,
            'punch_in_time' => date('Y-m-d H:i:s'),
            'action' => 'Punch In'
        );

        if($this->db->insert('attendance', $data)){
            echo json_encode(['return'=>true,'msg'=>'Punch In Successfully']);
        }else{
            echo json_encode(['return'=>false,'msg'=>'Punch In Failed!!']);
        }
        
    }
    public function punchOut()
    {
        $staff_id = $this->session->userdata('id');
        date_default_timezone_set('Asia/Kolkata');
        $data = array(
            'punch_out_time' => date('Y-m-d H:i:s'),
            'action' => 'Punch Out'
        );

        $this->db->where('staff_id', $staff_id);
        $this->db->where('punch_out_time', null); // Ensure we only update if punch_out_time is null
        $this->db->update('attendance', $data);
        echo json_encode(['return'=>true,'msg'=>'Punch out Successfully']);
    }
    public function fetch_product()
    {
        if ($this->input->post('category_id')) {
            $cid = $this->input->post('category_id');
            $this->model->fetch_product($cid,$this->input->post('product_id'));
        }
    }
    public function fetch_commision_level_by_cp()
    {
        if ($this->input->post('channel_partner_id')) {
            $cp_id = $this->input->post('channel_partner_id');
            $this->model->fetch_commision_level_by_cp($cp_id);
        }
    }
    public function fetch_commision()
    {
        if ($this->input->post('product_id')) {
            $p_id = $this->input->post('product_id');
            $cp_id = $this->input->post('channel_partner_id');
            $order_value = $this->input->post('order_value');
            $this->model->fetch_commision($p_id,$cp_id,$order_value);
        }
    }
}
