<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Commision extends CI_Controller {

	public function __construct()
    {
        parent::__construct();

        // $this->isAdminLoggedIn();
		$this->load->library('upload');

		
    }

    public function isAdminLoggedIn(){
        if($this->session->userdata('usertype') !== 'admin')
        {
            redirect(base_url('dashboard'));
            exit;
        }
    }

	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	
//commision level
public function commision_level()
{
	$data['title'] = 'Commision Level';
	$page = 'commision_level/index';
	$this->header_and_footer($page, $data);
}
public function addCommisionLevel()
{
	if($_POST['name'])
	{
		$countName = $this->model->countData('commision_level',['name'=>$_POST['name']]);
		if($countName > 0 )
		{
			echo json_encode(['return'=>false,'msg'=>'Already exist']);
		}
		else
		{
			$array = array(
				'name' => $_POST['name'],
				'description' => $_POST['description'],
			);
			if($this->commision_model->addCommisionLevel($array))
			{
				$lead_id = $this->db->insert_id();
				echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
			}
		}
	}
}
public function viewCommisionLevel()
{
	$data['list'] = $this->model->getResultData('commision_level',[],null,'id','DESC');
	$this->load->view('commision_level/tb',$data);
}
public function editCommisionLevel()
{
	$data = $this->model->getRowData('commision_level',['id'=>$_POST['id']]);
	$response = array(
		'id' => $_POST['id'],
		'name' => $data['name'],
		'description' => $data['description'],
		'icon' => base_url('assets/uploads/'.$data['icon'].''),
	);
	echo json_encode($response);
}
public function updateCommisionLevel()
{
	if(isset($_POST['id']))
	{
		$countName = $this->model->countData('commision_level',['name'=>$_POST['name'],'id!='=>$_POST['id']]);
		if($countName > 0 )
		{
			echo json_encode(['return'=>false,'msg'=>'Already exist']);
		}
		else
		{
			$array = array(
				'name' => $_POST['name'],
				'description' => $_POST['description'],
			);
			if($this->commision_model->updateCommisionLevel($array,$_POST['id']))
			{
				$lead_id = $_POST['id'];
				echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
			}
		}
	}
}

//commision
public function commision()
{
	$data['title'] = 'Commision';
	$data['categories'] = $this->model->getResultData('product_category',['is_disable'=>0]);
	$data['commision_levels'] = $this->model->getResultData('commision_level',['is_disable'=>0]);
	$page = 'commision/index';
	$this->header_and_footer($page, $data);
}
public function addCommision()
{
		if($_POST['category_id'])
		{
			$countCommision = $this->model->countData('commision',['product_id'=>$_POST['product_id'],'commision_level_id'=>$_POST['commision_level_id']]);
			if($countCommision > 0 )
			{
				echo json_encode(['return'=>false,'msg'=>'Commision for this level and product is already exist']);
			}
			else
			{
				$array = array(
					'category_id' => $_POST['category_id'],
					'product_id' => $_POST['product_id'],
					'commision_level_id' => $_POST['commision_level_id'],
					'commision_percentage' => $_POST['commision_percentage'],
				);
				if($this->model->add('commision',$array))
				{
					$lead_id = $this->db->insert_id();
					echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
				}
			}
			
		}
}
	public function viewCommision()
    {
		$data['list'] = $this->commision_model->getCommisionResultData();
		$this->load->view('commision/tb',$data);
    }
	public function editCommision()
    {
        $response=array();
		$data = $this->model->getRowData('commision',['id' => $_POST['id']]);
		$response = array(
			'id' => $_POST['id'],
			'category_id' => $data['category_id'],
			'product_id' => $data['product_id'],
			'commision_level_id' => $data['commision_level_id'],
			'commision_percentage' => $data['commision_percentage'],
		);
		echo json_encode($response);
    }        
	public function updateCommision()
    {
			if(isset($_POST['id']))
			{
				$countCommision = $this->model->countData('commision',['product_id'=>$_POST['product_id'],'commision_level_id'=>$_POST['commision_level_id'],'id!='=>$_POST['id']]);
				if($countCommision > 0 )
				{
					echo json_encode(['return'=>false,'msg'=>'Commision for this level and product is already exist']);
				}
				else
				{
					$array = array(
						'category_id' => $_POST['category_id'],
						'product_id' => $_POST['product_id'],
						'commision_level_id' => $_POST['commision_level_id'],
						'commision_percentage' => $_POST['commision_percentage'],
					);
					if($this->model->edit('commision',$array,['id'=>$_POST['id']]))
					{
						echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
					}
				}
			}
			else
			{
				echo json_encode(['return'=>false,'msg'=>'`id` is required']);
			}
			
		
    }
	//commisions
	public function commisions()
	{
		$data['title'] = 'Commisions';
		$page = 'commisions/index';
		$this->header_and_footer($page, $data);
	}
	public function viewCommisions()
	{
		$data['list'] = $this->model->getResultData('commision',[],null,'id','DESC');
		$this->load->view('commisions/tb',$data);
	}

	//cp commisions
	public function cp_commisions()
	{
		$data['title'] = 'Channel Partner Commisions';
		$page = 'cp_commisions/index';
		$this->header_and_footer($page, $data);
	}
	public function viewCpCommisions()
	{
		$data['list'] = $this->model->getResultData('channel_partner',[],null,'id','DESC');
		$this->load->view('cp_commisions/tb',$data);
	}
}
