        <div class="page-body">
          <div class="container-fluid">
            <div class="page-title">
              <div class="row">
                <div class="col-6">
                  <h3><?= $title; ?></h3>
                </div>
              </div>
            </div>
          </div>
          <!-- Container-fluid starts-->
          <div class="container-fluid">
            <div class="row">
              <div class="col-sm-12">
                <div class="card">
                  <div class="card-header">
                  <div class="row">
                  <div class="col-sm-6">
                    <h5><?= $title; ?></h5>
                  </div>
                  <div class="col-sm-6 text-right">
                    <button class="btn btn-success rounded add-btn" type="button" onclick="addDesign()"><i class="fa fa-plus"></i> Add <?= $title; ?></button>
                   </div>
                 </div>
                  </div>
                  <div class="card-body">
                    <div class="table-responsive" id="tb">

                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <!-- Container-fluid Ends-->
        </div>
        <!-- Modal -->
        <div class="modal fade modal-bookmark" id="addModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add <?= $title; ?></h5>
                <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
                <form class="form-bookmark" id="add-form" enctype="multipart/form-data">
                  <div class="row g-2">
                    
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Category <span class="text-danger">*</span></label>
                      <select class="form-control" id="category_id" name="category_id" onchange="fetch_product(this.value)" required>
                          <option value="">Select</option>
                          <?php foreach($categories as $category){ ?>
                            <option value="<?= $category['id'] ?>"><?= $category['name']; ?></option>
                          <?php } ?>
                        </select>
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Product</label>
                      <select name="product_id" class="product form-control" id="product_id">
                      </select>                    
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Design Name <span class="text-danger">*</span></label>
                      <input class="form-control" id="name" type="text" name="name" required>
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="icon">MRP</label>
                      <input class="form-control" type="number" id="mrp" name="mrp">
                   </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Image</label>
                      <input type="file" name="image[]" class="form-control" size="55550" accept=".png, .jpg, .jpeg" multiple="" required>
                    </div>  
                    <div class="mb-3 mt-0 col-md-12">
                      <label for="bm-title">Description</label>
                      <textarea class="form-control" id="description" type="text" name="description"></textarea>
                    </div>
                    
                  
                    
                  </div>
                  <button class="btn btn-secondary" type="submit">Add</button>
                  <button class="btn btn-primary" type="button" data-bs-dismiss="modal">Cancel</button>
                </form>
              </div>
            </div>
          </div>
        </div>

        <!-- Modal -->
        <div class="modal fade modal-bookmark" id="editModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Edit Design</h5>
                <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
              <form class="form-bookmark" id="edit-form">
                  <div class="row g-2">
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Category <span class="text-danger">*</span></label>
                      <select class="form-control" id="e_category_id" name="category_id" onchange="fetch_product(this.value)" required>
                          <option value="">Select</option>
                          <?php foreach($categories as $category){ ?>
                            <option value="<?= $category['id'] ?>"><?= $category['name']; ?></option>
                          <?php } ?>
                        </select>
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Product</label>
                      <select name="product_id" class="product form-control" id="e_product">
                      </select>                    
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Design Name <span class="text-danger">*</span></label>
                      <input class="form-control" id="e_name" type="text" name="name" required>
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                    <label for="icon">MRP</label>
                   <input class="form-control" type="number" id="e_mrp" name="mrp">
                   </div>
                    <div class="mb-3 mt-0 col-md-12">
                      <label for="bm-title">Description</label>
                      <textarea class="form-control" id="e_description" type="text" name="description"></textarea>
                    </div>
                      
                  </div>
                  <input type="hidden" id="e_id" name="id">
                  <button class="btn btn-secondary" type="submit">Update</button>
                  <button class="btn btn-primary" type="button" data-bs-dismiss="modal">Cancel</button>
              </form>
              </div>
            </div>
          </div>
        </div>
<!-- Image Modal -->
<div class="modal fade modal-bookmark" id="designImageModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Design Images</h5>
        <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <div class="row">
          <div class="col-md-12 mb-5">
            <form class="form-bookmark" id="design-image-form">
              <input type="file" name="design_image" id="design_image" required>
              <button type="submit" class="btn btn-primary btn-sm">Add</button>
              <input type="hidden" name="design_id" id="design_id">
            </form>
          </div>
          <div class="col-md-12">
            <table class="table table-bordered">
              <thead>
                <tr>
                  <th scope="col">S.No.</th>
                  <th scope="col">Image</th>
                  <th scope="col">Action</th>
                </tr>
              </thead>
              <tbody class="images">
                
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<script>
  function addDesign()
  {
    $('#addModal').modal('toggle'); 
    $('#add-form')[0].reset();
    
  }
$(document).ready(function(){
  $('#addModal').modal({
           backdrop: 'static',
           keyboard: false
    })
    $('#editModal').modal({
           backdrop: 'static',
           keyboard: false
    })
  $('#tb').load('<?= base_url('design/viewDesign'); ?>');
});


$("#add-form").submit(function(e){
  e.preventDefault();
  disableButton();
  $.ajax({
      url: "<?php echo base_url('design/addDesign'); ?>",
      method: "POST",
      data:  new FormData(this),
      cache: false,
      contentType: false,
      processData: false,
  
      dataType:'json',
      success:function(res){
        enableButton();
        if(res.return)
        {
          $('#addModal').modal('toggle'); 
          $('#add-form')[0].reset();
          $('#tb').load('<?= base_url('design/viewDesign'); ?>');
          toastr.success(res.msg);
        }
        else
        {
          toastr.error(res.msg);
        }
      }
  });
})
function editDesign(id)
{
  $.ajax({
      url: "<?= base_url('design/editDesign'); ?>",
      method: "POST",
        dataType: 'json',
      data: {
          id:id
      },
      success:function(res){
          fetch_product(res.category_id,res.product_id);
          $("#e_id").val(res.id);
          $("#e_name").val(res.name);
          $("#e_category_id").val(res.category_id);
          $("#e_mrp").val(res.mrp);
          $("#e_description").val(res.description);
         
      }
  });
};
$("#edit-form").submit(function(e){
  e.preventDefault();
  disableButton();
  $.ajax({
      url: "<?php echo base_url('design/updateDesign'); ?>",
      method: "POST",
      data:  new FormData(this),
      cache: false,
      contentType: false,
      processData: false,
      dataType:'json',
      success:function(res){
        enableButton();
        if(res.return)
        {
          $('#editModal').modal('toggle'); 
          $('#tb').load('<?= base_url('design/viewDesign'); ?>');
          toastr.success(res.msg);
        }
        else
        {          
          toastr.error(res.msg);
        }
      }
  });
})
function designImage(id)
{
  $.ajax({
      url: "<?php echo base_url('design/designImage'); ?>",
      method: "POST",
      data: {
        design_id:id
      },
      success:function(res){
        $("#design_id").val(id);
        $('.images').html(res);
      }
  });
};
$("#design-image-form").submit(function(e){
  e.preventDefault();
  disableButton();
  var formData = new FormData(this);
  $.ajax({
      url: "<?php echo base_url('design/addDesignImage'); ?>",
      method: "POST",
      data:  formData,
      cache: false,
      contentType: false,
      processData: false,
      dataType:'json',
      success:function(res){
        enableButton();
        if(res.return)
        {
          $('#design_image').val('');
          designImage($('#design_id').val());
          toastr.success(res.msg);
        }
        else
        {
          toastr.error(res.msg);
        }
      }
  });
});
function deleteDesignImage(image_id,design_id)
{
  if (confirm('Are you sure?') == true) {
    $.ajax({
        url: "<?php echo base_url('design/deleteDesignImage'); ?>",
        method: "POST",
        data:  {
          'image_id':image_id
        },
        dataType:'json',
        success:function(res){
          if(res.return)
          {
            designImage(design_id);
            toastr.success(res.msg);
          }
          else
          {
            toastr.error(res.msg);
          }
        }
    });
  }
}
function makeDesignCoverImage(image_id,design_id)
{
  if (confirm('Are you sure?') == true) {
    $.ajax({
        url: "<?php echo base_url('design/makeDesignCoverImage'); ?>",
        method: "POST",
        data:  {
          'image_id':image_id,
          'design_id':design_id,
        },
        dataType:'json',
        success:function(res){
          if(res.return)
          {
            designImage(design_id);
            toastr.success(res.msg);
          }
          else
          {
            toastr.error(res.msg);
          }
        }
    });
  }
}
function designDeleteAlert()
{
  toastr.error('Cover image can not be delete');
}
function fetch_product(category_id,product_id) {
  $.ajax({
    url: "<?= base_url('dashboard/fetch_product'); ?>",
    method: "POST",
    data: {
      category_id: category_id,
      product_id: product_id
    },
    success: function(data) {
      if(product_id == null)
      {
        $(".product").html(data);
      }
      else
      {
        $("#e_product").html(data);
      }
    },
  });
}
</script>