<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Customer extends CI_Controller {

	public function __construct()
    {
        parent::__construct();

        $this->isAdminLoggedIn();
    }

    public function isAdminLoggedIn(){
        if($this->session->userdata('usertype') !== 'admin' && $this->session->userdata('usertype') !== 'staff')
        {
            redirect(base_url('dashboard'));
            exit;
        }
    }

	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	public function index()
    {
        $data['title'] = 'Customer';
		$data['countries'] = $this->model->getResultData('countries',[]);
		// $data['companies'] = $this->model->getResultData('company',['is_disable'=>0]);
        $page = 'customer/index';
        $this->header_and_footer($page, $data);
    }
	public function addCustomer()
    {
		$personEmailExists = $this->model->countData('customer',['person_emailid'=>$_POST['person_emailid']]);

		if ($personEmailExists > 0) {
			echo json_encode(['return'=>false,'msg'=>'Person Email already exists']);
		}
		else
		{
			if($_POST['fullname'])
			{
				$array = array(
					'fullname' => ucfirst($_POST['fullname']),
					// 'company' => $_POST['company'],
					'mobile' =>  '+'.$_POST['ccode'].' '.$_POST['mobile'],
					'person_emailid' => $_POST['person_emailid'],
					'pan_no' => $_POST['pan_no'],
					'country' => $_POST['country'],
					'state' => $_POST['state'],
					'city' => $_POST['city'],
					'address' => $_POST['address'],
				);
				if($this->customer_model->addCustomer($array))
				{
					$lead_id = $this->db->insert_id();
					$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'add','customer detail');

					echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
				}
				
			}
		}
    }
	public function viewCustomer()
    {
		$data['list'] = $this->customer_model->getCustomerResultData();
		$this->load->view('customer/tb',$data);
    }
	public function editCustomer()
    {
        $response=array();
		$data = $this->model->getRowData('customer',['id' => $_POST['id']]);
		if($data['mobile'] !== '')
		{
			$mob = explode(' ',$data['mobile']);
			$ccode = $mob[0];
			$contact = $mob[1];
		}else{
			$mob = '';
			$ccode = '';
			$contact = '';
		}
		$response = array(
			'id' => $_POST['id'],
			// 'company' => $data['company'],
			'fullname' => $data['fullname'],
			'mobile' => $contact,
			'ccode' => str_replace("+","",$ccode),
			'person_emailid' => $data['person_emailid'],
			'pan_no' => $data['pan_no'],
			'visiting_card' => base_url('assets/uploads/'.$data['visiting_card'].''),
			'country' => $data['country'],
			'state' => $data['state'],
			'city' => $data['city'],
			'address' => $data['address'],
		);
		echo json_encode($response);
    }
	public function updateCustomer()
    {
		$personEmailExists = $this->model->countData('customer',['person_emailid'=>$_POST['person_emailid'],'id!='=>$_POST['id']]);
		if($personEmailExists > 0 )
		{
			echo json_encode(['return'=>false,'msg'=>'Email already exist']);
		}else
		{
			if(isset($_POST['id']))
			{
				$array = array(
					'fullname' => ucfirst($_POST['fullname']),
					// 'company' => $_POST['company'],
					'mobile' =>  '+'.$_POST['ccode'].' '.$_POST['mobile'],
					'person_emailid' => $_POST['person_emailid'],
					'pan_no' => $_POST['pan_no'],
					'country' => $_POST['country'],
					'state' => $_POST['state'],
					'city' => $_POST['city'],
					'address' => $_POST['address'],
				);
				if($this->customer_model->updateCustomer($array,$_POST['id']))
				{
					$lead_id = $_POST['id'];
					$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'edit','customer detail');
					echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
				}
			}
			else
			{
				echo json_encode(['return'=>false,'msg'=>'`id` is required']);
			}
		}
    }
  
    public function detail()
    {
        $id=$this->uri->segment(2);
        $data['title'] = 'Customer Detail';
		$data['data'] = $this->customer_model->getCustomerRowData($id);
        $page = 'customer/detail';
        $this->header_and_footer($page, $data);
    }

}
