<main id="main" class="main">

    <div class="pagetitle">
      <h1>Dashboard</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="<?= base_url('dashboard');?>">Home</a></li>
          <li class="breadcrumb-item active">Dashboard</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->

    <section class="section dashboard">
      <div class="row">
        <!-- Container starts-->
        <div class="container">
          <div class="row size-column">
            <div class="col-xl-12 box-col-12 xl-100">
              <div class="row dash-chart">
                <div class="col-xl-12 box-col-7 col-lg-12 col-md-12">
                  <div class="card">
                    <div class="card-body">
                      <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                          <i class="fas fa-tasks fa-3x text-primary"></i>
                        </div>
                        <div class="flex-grow-1 ms-3 mt-3">
                          <p class="f-w-500 font-roboto-bold-700">AMCs Expiring Soon</p>
                          <h4 class="f-w-500 mb-0 fs-5">Within Next 2 Months</h4>
                        </div>
                      </div>
                      <!-- AMC List Table -->
                      <div class="table-responsive mt-3">
                        <table class="table table-bordered table-striped">
                          <thead class="table-primary">
                            <tr>
                              <th>Client Name</th>
                              <th>Total Hours</th>
                              <th>Remaining AMC Hours</th>
                              <th>AMC Start Date</th>
                              <th>AMC End Date</th>
                            </tr>
                          </thead>
                          <tbody>
                            <?php foreach($expiring_amcs as $amc){ ?>
                              <tr>
                                <td><?= $amc['fullname']; ?></td>
                                <td><?= $amc['total_hours']; ?></td>
                                <td><?= calculate_remaining_hours($amc['id']); ?></td>
                                <td><?= date('d-m-Y',strtotime($amc['amc_start_date'])); ?></td>
                                <td class="text-danger"><?= date('d-m-Y',strtotime($amc['amc_end_date'])); ?></td>
                              </tr>
                            <?php } ?>
                          </tbody>
                        </table>
                      </div>
                    </div>
                  </div>
                </div>

                <!--Remaining hours-->
                <div class="col-xl-12 box-col-7 col-lg-12 col-md-12">
                  <div class="card">
                    <div class="card-body">
                      <!-- Client and AMC Selection -->
                      <div class="row mt-4">
                        <div class="col-md-12 mb-3">
                          <h5>Select a client and AMC to view remaining hours</h5>
                        </div>
                        <div class="col-md-6">
                          <label class="form-label">Client</label>
                          <select class="form-select" id="client_id" name="client_id" onchange="fetch_amc(this.value)">
                            <option value="">Select Client</option>
                            <?php foreach($clients as $client){ ?>
                              <option value="<?= $client['id']; ?>"><?= $client['fullname']; ?></option>
                            <?php } ?>
                          </select>
                        </div>
                        <div class="col-md-6">
                          <label class="form-label">AMC</label>
                          <select name="amc_id" class="form-select amc" id="amc_id" onchange="fetch_remaining_hours(this.value)">
                          </select>                    
                        </div>
                        <div class="col-md-12 mt-3">
                          <div class="remaining-hours">
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>

              </div>
            </div>
          </div>
        </div>
      </div>
</section>
       
  </main><!-- End #main -->



  <script>
    function fetch_amc(client_id,amc_id) {
  $.ajax({
    url: "<?= base_url('dashboard/fetch_amc'); ?>",
    method: "POST",
    data: {
      client_id: client_id,
      amc_id: amc_id
    },
    success: function(data) {
      if(amc_id == null)
      {
        $(".amc").html(data);
      }
      else
      {
        $("#e_amc_id").html(data);
      }
    },
  });
}
function fetch_remaining_hours(amc_id){
  $.ajax({
    url: "<?= base_url('efforts/fetch_remaining_hours'); ?>",
    method: "POST",
    data: {
      amc_id: amc_id
    },
    success: function(data) {
        $('.remaining-hours').html(data);
    },
  });
}
  </script>