

  <main id="main" class="main">

    <section class="section">
      <div class="row">
        <div class="col-lg-12">

          <div class="card">
              <div class="card-header mb-4">
                <div class="row">
                  <div class="col-sm-6">
                    <h4 class="text-dark"><?= $title; ?></h4>
                  </div>
                  <div class="col-sm-6" style="text-align: right;">
                    <button class="btn btn-success rounded add-btn" type="button" onclick="add()"><i class="bi bi-plus"></i> Add <?= $title; ?></button>
                  </div>
                 </div>

            </div>
            <div class="card-body">
              <!-- Table with stripped rows -->
              <div class="table-responsive" id="tb">
                    </div>
              <!-- End Table with stripped rows -->

            </div>
          </div>

        </div>
      </div>
    </section>

  </main><!-- End #main -->
   <!-- Add Modal -->
        <div class="modal fade modal-bookmark" id="addModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add <?= $title; ?></h5>
                <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
                <form class="row g-3" id="add-form">
                  <div class="col-md-6">
                    <label class="form-label">Fullname</label>
                    <input type="text" class="form-control" id="fullname" name="fullname" required>
                  </div>
                  <div class="col-md-6">
                    <label class="form-label">Mobile</label>
                    <input type="text" pattern="[1-9]{1}[0-9]{9}" title="Enter 10 digit contact number" maxlength="10" class="form-control" id="mobile" name="mobile">
                  </div>
                  <div class="col-md-6">
                    <label class="form-label">Email</label>
                    <input type="email" class="form-control" id="email" name="email">
                  </div>
                  <div class="col-md-6">
                    <label class="form-label">Website</label>
                    <input type="text" class="form-control" id="website" name="website">
                  </div>
                  <div class="col-12">
                    <label class="form-label">Address</label>
                    <textarea class="form-control" id="address" name="address"></textarea>
                  </div>
                  <div class="text-left">
                    <button type="submit" class="btn btn-primary">Save</button>
                    <button type="reset" class="btn btn-danger">Reset</button>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>

      <!-- Edit Modal -->
      <div class="modal fade modal-bookmark" id="editModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
          <div class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title" id="exampleModalLabel">Add <?= $title; ?></h5>
              <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
              <form class="row g-3" id="edit-form">
                <div class="col-md-6">
                  <label class="form-label">Fullname</label>
                  <input type="text" class="form-control" id="e_fullname" name="fullname" required>
                </div>
                <div class="col-md-6">
                  <label class="form-label">Mobile</label>
                  <input type="text" pattern="[1-9]{1}[0-9]{9}" title="Enter 10 digit contact number" maxlength="10" class="form-control" id="e_mobile" name="mobile">
                </div>
                <div class="col-md-6">
                  <label class="form-label">Email</label>
                  <input type="email" class="form-control" id="e_email" name="email">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Website</label>
                    <input type="text" class="form-control" id="e_website" name="website">
                </div>
                <div class="col-12">
                  <label class="form-label">Address</label>
                  <textarea class="form-control" id="e_address" name="address"></textarea>
                  <input type="hidden" name="id" id="e_id">
                </div>
                <div class="text-left">
                  <button type="submit" class="btn btn-primary">Save</button>
                  <button type="reset" class="btn btn-danger">Reset</button>
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
<script>
  function add()
  {
    $('#addModal').modal('toggle'); 
    $('#add-form')[0].reset();
  }
$(document).ready(function(){  
$("#tb").html('<div class="text-center"><img src="loader.gif"></div>')
  $('#addModal').modal({
           backdrop: 'static',
           keyboard: false
    })
    $('#editModal').modal({
           backdrop: 'static',
           keyboard: false
    })
  $('#tb').load('<?= base_url('client/viewClient'); ?>');
});


$("#add-form").submit(function(e){
  e.preventDefault();
  disableButton();
  $.ajax({
      url: "<?php echo base_url('client/addClient'); ?>",
      method: "POST",
      data:  new FormData(this),
      cache: false,
      contentType: false,
      processData: false,
      dataType:'json',
      success:function(res){
        enableButton();
        if(res.return)
        {
          $('#addModal').modal('toggle'); 
          $('#add-form')[0].reset();
          $('#tb').load('<?= base_url('client/viewClient'); ?>');
          toastr.success(res.msg);
        }
        else
        {
          toastr.error(res.msg);
        }
        
      }
  });
})

function editData(id)
{
  $.ajax({
      url: "<?= base_url('client/editClient'); ?>",
      method: "POST",
        dataType: 'json',
      data: {
          id:id
      },
      success:function(res){
          $("#e_id").val(res.id);
          $("#e_fullname").val(res.fullname);
          $("#e_mobile").val(res.mobile);
          $("#e_website").val(res.website);
          $("#e_email").val(res.email);
          $("#e_address").val(res.address);
      }
  });
};
$("#edit-form").submit(function(e){
  e.preventDefault();
  disableButton();
  $.ajax({
      url: "<?php echo base_url('client/updateClient'); ?>",
      method: "POST",
      data:  new FormData(this),
      cache: false,
      contentType: false,
      processData: false,
      dataType:'json',
      success:function(res){
        enableButton();
        if(res.return)
        {
          $('#editModal').modal('toggle'); 
          $('#edit-form')[0].reset();
          $('#tb').load('<?= base_url('client/viewClient'); ?>');
          toastr.success(res.msg);
        }
        else
        {
          toastr.error(res.msg);
        }
        
      }
  });
})
</script>