

  <main id="main" class="main">

    <section class="section">
      <div class="row">
        <div class="col-lg-12">

          <div class="card">
              <div class="card-header mb-4">
                <div class="row">
                  <div class="col-sm-6">
                    <h4 class="text-dark"><?= $title; ?></h4>
                  </div>
                  <div class="col-sm-6" style="text-align: right;">
                    <button class="btn btn-success rounded add-btn" type="button" onclick="add()"><i class="bi bi-plus"></i> Add <?= $title; ?></button>
                  </div>
                 </div>

            </div>
            <div class="card-body">
              <!-- Table with stripped rows -->
              <div class="table-responsive" id="tb">
                    </div>
              <!-- End Table with stripped rows -->

            </div>
          </div>

        </div>
      </div>
    </section>

  </main><!-- End #main -->
   <!-- Add Modal -->
        <div class="modal fade modal-bookmark" id="addModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add <?= $title; ?></h5>
                <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
              <form class="row g-3" id="add-form">
                <div class="col-md-6">
                  <label class="form-label">Amc</label>
                  <select class="form-select" id="client_id" name="client_id">
                    <option value="">Select</option>
                    <?php foreach($clients as $client){ ?>
                      <option value="<?= $client['id']; ?>"><?= $client['fullname']; ?></option>
                    <?php } ?>
                  </select>
                </div>
                <div class="col-md-6">
                  <label class="form-label">Total Hours</label>
                  <input type="number" class="form-control" id="total_hours" name="total_hours" min="1" step="1">
                </div>
                <div class="col-md-6">
                  <label class="form-label">AMC Start Date</label>
                  <input type="date" class="form-control" id="amc_start_date" name="amc_start_date">
                </div>
                <div class="col-md-6">
                  <label class="form-label">AMC End Date</label>
                  <input type="date" class="form-control" id="amc_end_date" name="amc_end_date">
                </div>
                <div class="text-left">
                  <button type="submit" class="btn btn-primary">Save</button>
                  <button type="reset" class="btn btn-danger">Reset</button>
                </div>
              </form>

              </div>
            </div>
          </div>
        </div>

      <!-- Edit Modal -->
      <div class="modal fade modal-bookmark" id="editModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
          <div class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title" id="exampleModalLabel">Add <?= $title; ?></h5>
              <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
              <form class="row g-3" id="edit-form">
                <div class="col-md-6">
                  <label class="form-label">Amc</label>
                  <select class="form-select" id="e_client_id" name="client_id">
                    <option value="">Select</option>
                    <?php foreach($clients as $client){ ?>
                      <option value="<?= $client['id']; ?>"><?= $client['fullname']; ?></option>
                    <?php } ?>
                  </select>
                </div>
                <div class="col-md-6">
                  <label class="form-label">Total Hours</label>
                  <input type="number" class="form-control" id="e_total_hours" name="total_hours" min="1" step="1">
                </div>
                <div class="col-md-6">
                  <label class="form-label">AMC Start Date</label>
                  <input type="date" class="form-control" id="e_amc_start_date" name="amc_start_date">
                </div>
                <div class="col-md-6">
                  <label class="form-label">AMC End Date</label>
                  <input type="date" class="form-control" id="e_amc_end_date" name="amc_end_date">
                </div>
                <div class="text-left">
                  <input type="hidden" name="id" id="e_id">
                  <button type="submit" class="btn btn-primary">Save</button>
                  <button type="reset" class="btn btn-danger">Reset</button>
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
<script>
  function add()
  {
    $('#addModal').modal('toggle'); 
    $('#add-form')[0].reset();
    $('#amc_id').find('option:not(:first)').remove();
  }
$(document).ready(function(){  
$("#tb").html('<div class="text-center"><img src="loader.gif"></div>')
  $('#addModal').modal({
           backdrop: 'static',
           keyboard: false
    })
    $('#editModal').modal({
           backdrop: 'static',
           keyboard: false
    })
  $('#tb').load('<?= base_url('amc/viewAmc'); ?>');
});


$("#add-form").submit(function(e){
  e.preventDefault();
  disableButton();
  $.ajax({
      url: "<?php echo base_url('amc/addAmc'); ?>",
      method: "POST",
      data:  new FormData(this),
      cache: false,
      contentType: false,
      processData: false,
      dataType:'json',
      success:function(res){
        enableButton();
        if(res.return)
        {
          $('#addModal').modal('toggle'); 
          $('#add-form')[0].reset();
          $('#tb').load('<?= base_url('amc/viewAmc'); ?>');
          toastr.success(res.msg);
        }
        else
        {
          toastr.error(res.msg);
        }
        
      }
  });
})

function editData(id)
{
  $.ajax({
      url: "<?= base_url('amc/editAmc'); ?>",
      method: "POST",
        dataType: 'json',
      data: {
          id:id
      },
      success:function(res){
          $("#e_id").val(res.id);
          $("#e_client_id").val(res.client_id);
          $("#e_total_hours").val(res.total_hours);
          $("#e_amc_start_date").val(res.amc_start_date);
          $("#e_amc_end_date").val(res.amc_end_date);
      }
  });
};
$("#edit-form").submit(function(e){
  e.preventDefault();
  disableButton();
  $.ajax({
      url: "<?php echo base_url('amc/updateAmc'); ?>",
      method: "POST",
      data:  new FormData(this),
      cache: false,
      contentType: false,
      processData: false,
      dataType:'json',
      success:function(res){
        enableButton();
        if(res.return)
        {
          $('#editModal').modal('toggle'); 
          $('#edit-form')[0].reset();
          $('#tb').load('<?= base_url('amc/viewAmc'); ?>');
          toastr.success(res.msg);
        }
        else
        {
          toastr.error(res.msg);
        }
        
      }
  });
})
</script>