<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Amc extends CI_Controller {
	public function __construct()
    {
        parent::__construct();

        // $this->isAdminLoggedIn();
    }
    public function isAdminLoggedIn()
	{
        if($this->session->userdata('usertype') !== 'admin' && $this->session->userdata('usertype') !== 'staff')
        {
            redirect(base_url('dashboard'));
            exit;
        }
    }
	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	public function index()
    {
        $data['title'] = 'Amc';
		$data['clients'] = $this->model->getResultData('client',['is_suspended'=>0]);
        $page = 'amc/index';
        $this->header_and_footer($page, $data);
    }
	
  
	public function addAmc()
    {
		$array = array(
			'client_id' => $_POST['client_id'],
			'total_hours' => $_POST['total_hours'],
			'amc_start_date' => $_POST['amc_start_date'],
			'amc_end_date' => $_POST['amc_end_date'],
		);
		
		if($this->model->add('amc',$array))
		{  
			$lead_id = $this->db->insert_id();
			$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'add','amc');
			echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
		} 
		
    }
	public function viewAmc()
    {
		$data['list'] = $this->amc_model->getAmcResultData();
		$this->load->view('amc/tb',$data);
    }
	public function editAmc()
    {
        $response=array();
		$data = $this->model->getRowData('amc',['id' => $_POST['id']]);
		$response = array(
			'id' => $_POST['id'],
			'client_id' => $data['client_id'],
			'total_hours' => $data['total_hours'],
			'amc_start_date' => $data['amc_start_date'],
			'amc_end_date' => $data['amc_end_date'],
		);
		echo json_encode($response);
    }
	public function updateAmc()
    {
		if(isset($_POST['id']))
		{
			$array = array(
				'client_id' => $_POST['client_id'],
				'total_hours' => $_POST['total_hours'],
				'amc_start_date' => $_POST['amc_start_date'],
				'amc_end_date' => $_POST['amc_end_date'],
			);
			
			if($this->model->edit('amc',$array,['id'=>$_POST['id']]))
			{
				$lead_id = $_POST['id'];
				$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'edit','amc');

				echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
			}
		}
	}
    public function detail()
    {
        $id=$this->uri->segment(2);
        $data['title'] = 'Amc Detail';
		$data['data'] = $this->amc_model->getAmcRowData($id);
        $page = 'amc/detail';
        $this->header_and_footer($page, $data);
    }
	
   	
}
