

  <main id="main" class="main">

    <section class="section">
      <div class="row">
        <div class="col-lg-12">

          <div class="card">
              <div class="card-header mb-4">
                <div class="row">
                  <div class="col-sm-6">
                    <h4 class="text-dark"><?= $title; ?></h4>
                  </div>
                  <div class="col-sm-6" style="text-align: right;">
                    <button class="btn btn-success rounded add-btn" type="button" onclick="add()"><i class="bi bi-plus"></i> Add <?= $title; ?></button>
                  </div>
                 </div>

            </div>
            <div class="card-body">
              <!-- Table with stripped rows -->
              <div class="table-responsive" id="tb">
                    </div>
              <!-- End Table with stripped rows -->

            </div>
          </div>

        </div>
      </div>
    </section>

  </main><!-- End #main -->
   <!-- Add Modal -->
        <div class="modal fade modal-bookmark" id="addModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add <?= $title; ?></h5>
                <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
              <form class="row g-3" id="add-form">
                <div class="col-md-6">
                  <label class="form-label">Client</label>
                  <select class="form-select" id="client_id" name="client_id" onchange="fetch_amc(this.value)">
                    <option value="">Select</option>
                    <?php foreach($clients as $client){ ?>
                      <option value="<?= $client['id']; ?>"><?= $client['fullname']; ?></option>
                    <?php } ?>
                  </select>
                </div>
                <div class="col-md-6">
                  <label class="form-label">AMC</label>
                  <select name="amc_id" class="amc form-control" id="amc_id" onchange="fetch_remaining_hours(this.value)">
                  </select>                    
                </div>
                <div class="col-md-12 remaining-hours">                    
                </div>
                <div class="col-md-6">
                  <label class="form-label">No. of Hours</label>
                  <input type="number" class="form-control" id="no_of_hours" name="no_of_hours" min="1" step="1">
                </div>
                <div class="col-md-6">
                  <label class="form-label">Datetime</label>
                  <input type="datetime-local" class="form-control" id="datetime" name="datetime" value="<?= date('Y-m-d\TH:i'); ?>">
                </div>
                <div class="col-md-12">
                  <label class="form-label">Task details</label>
                  <textarea class="form-control" id="task_details" name="task_details"></textarea>
                </div>
                <div class="text-left">
                  <button type="submit" class="btn btn-primary">Save</button>
                  <button type="reset" class="btn btn-danger">Reset</button>
                </div>
              </form>

              </div>
            </div>
          </div>
        </div>

      <!-- Edit Modal -->
      <div class="modal fade modal-bookmark" id="editModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
          <div class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title" id="exampleModalLabel">Add <?= $title; ?></h5>
              <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
              <form class="row g-3" id="edit-form">
                <div class="col-md-6">
                  <label class="form-label">Client</label>
                  <select class="form-select" id="e_client_id" name="client_id" onchange="fetch_amc(this.value)">
                    <option value="">Select</option>
                    <?php foreach($clients as $client){ ?>
                      <option value="<?= $client['id']; ?>"><?= $client['fullname']; ?></option>
                    <?php } ?>
                  </select>
                </div>
                <div class="col-md-6">
                  <label class="form-label">AMC</label>
                  <select name="amc_id" class="amc form-control" id="e_amc_id">
                  </select>                    
                </div>
                <div class="col-md-6">
                  <label class="form-label">No. of Hours</label>
                  <input type="number" class="form-control" id="e_no_of_hours" name="no_of_hours" min="1" step="1">
                </div>
                <div class="col-md-6">
                  <label class="form-label">Datetime</label>
                  <input type="datetime-local" class="form-control" id="e_datetime" name="datetime">
                </div>
                <div class="col-md-12">
                  <label class="form-label">Task details</label>
                  <textarea class="form-control" id="e_task_details" name="task_details"></textarea>
                </div>
                <div class="text-left">
                  <input type="hidden" name="id" id="e_id">
                  <button type="submit" class="btn btn-primary">Save</button>
                  <button type="reset" class="btn btn-danger">Reset</button>
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
<script>
  function add()
  {
    $('#addModal').modal('toggle'); 
    $('#add-form')[0].reset();
    $('.remaining-hours').html(''); 
  }
$(document).ready(function(){  
$("#tb").html('<div class="text-center"><img src="loader.gif"></div>')
  $('#addModal').modal({
           backdrop: 'static',
           keyboard: false
    })
    $('#editModal').modal({
           backdrop: 'static',
           keyboard: false
    })
  $('#tb').load('<?= base_url('efforts/viewEfforts'); ?>');
});


$("#add-form").submit(function(e){
  e.preventDefault();
  disableButton();
  $.ajax({
      url: "<?php echo base_url('efforts/addEfforts'); ?>",
      method: "POST",
      data:  new FormData(this),
      cache: false,
      contentType: false,
      processData: false,
      dataType:'json',
      success:function(res){
        enableButton();
        if(res.return)
        {
          $('#addModal').modal('toggle'); 
          $('#add-form')[0].reset();
          $('#tb').load('<?= base_url('efforts/viewEfforts'); ?>');
          toastr.success(res.msg);
        }
        else
        {
          toastr.error(res.msg);
        }
        
      }
  });
})

function editData(id)
{
  $.ajax({
      url: "<?= base_url('efforts/editEfforts'); ?>",
      method: "POST",
        dataType: 'json',
      data: {
          id:id
      },
      success:function(res){
          fetch_amc(res.client_id,res.amc_id);
          $("#e_id").val(res.id);
          $("#e_client_id").val(res.client_id);
          $("#e_no_of_hours").val(res.no_of_hours);
          $("#e_datetime").val(res.datetime);
          $("#e_task_details").val(res.task_details);
      }
  });
};
$("#edit-form").submit(function(e){
  e.preventDefault();
  disableButton();
  $.ajax({
      url: "<?php echo base_url('efforts/updateEfforts'); ?>",
      method: "POST",
      data:  new FormData(this),
      cache: false,
      contentType: false,
      processData: false,
      dataType:'json',
      success:function(res){
        enableButton();
        if(res.return)
        {
          $('#editModal').modal('toggle'); 
          $('#edit-form')[0].reset();
          $('#tb').load('<?= base_url('efforts/viewEfforts'); ?>');
          toastr.success(res.msg);
        }
        else
        {
          toastr.error(res.msg);
        }
        
      }
  });
})
function fetch_amc(client_id,amc_id) {
  $.ajax({
    url: "<?= base_url('dashboard/fetch_amc'); ?>",
    method: "POST",
    data: {
      client_id: client_id,
      amc_id: amc_id
    },
    success: function(data) {
      if(amc_id == null)
      {
        $(".amc").html(data);
      }
      else
      {
        $("#e_amc_id").html(data);
      }
    },
  });
}
function fetch_remaining_hours(amc_id){
  $.ajax({
    url: "<?= base_url('efforts/fetch_remaining_hours'); ?>",
    method: "POST",
    data: {
      amc_id: amc_id
    },
    success: function(data) {
        $('.remaining-hours').html(data);
    },
  });
}
</script>