<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Efforts extends CI_Controller {
	public function __construct()
    {
        parent::__construct();

        // $this->isAdminLoggedIn();
    }
    public function isAdminLoggedIn()
	{
        if($this->session->userdata('usertype') !== 'admin' && $this->session->userdata('usertype') !== 'staff')
        {
            redirect(base_url('dashboard'));
            exit;
        }
    }
	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	public function index()
    {
        $data['title'] = 'Efforts';
		$data['clients'] = $this->model->getResultData('client',['is_suspended'=>0]);
        $page = 'efforts/index';
        $this->header_and_footer($page, $data);
    }
	
  
	public function addEfforts()
    {
		$array = array(
			'client_id' => $_POST['client_id'],
			'amc_id' => $_POST['amc_id'],
			'no_of_hours' => $_POST['no_of_hours'],
			'datetime' => $_POST['datetime'],
			'task_details' => $_POST['task_details'],
		);
		
		if($this->model->add('efforts',$array))
		{  
			$lead_id = $this->db->insert_id();
			$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'add','efforts');
			echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
		} 
		
    }
	public function viewEfforts()
    {
		$data['list'] = $this->efforts_model->getEffortsResultData();
		$this->load->view('efforts/tb',$data);
    }
	public function editEfforts()
    {
        $response=array();
		$data = $this->model->getRowData('efforts',['id' => $_POST['id']]);
		$response = array(
			'id' => $_POST['id'],
			'client_id' => $data['client_id'],
			'amc_id' => $data['amc_id'],
			'no_of_hours' => $data['no_of_hours'],
			'datetime' => $data['datetime'],
			'task_details' => $data['task_details'],
		);
		echo json_encode($response);
    }
	public function updateEfforts()
    {
		if(isset($_POST['id']))
		{
			$array = array(
				'client_id' => $_POST['client_id'],
				'amc_id' => $_POST['amc_id'],
				'no_of_hours' => $_POST['no_of_hours'],
				'datetime' => $_POST['datetime'],
				'task_details' => $_POST['task_details'],
			);
			
			if($this->model->edit('efforts',$array,['id'=>$_POST['id']]))
			{
				$lead_id = $_POST['id'];
				$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'edit','efforts');

				echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
			}
		}
	}
    public function detail()
    {
        $id=$this->uri->segment(2);
        $data['title'] = 'Efforts Detail';
		$data['data'] = $this->efforts_model->getEffortsRowData($id);
        $page = 'efforts/detail';
        $this->header_and_footer($page, $data);
    }
	public function fetch_remaining_hours()
	{
		if($_POST['amc_id']){
		echo "
		<div style='padding: 20px; background-color: #f1f1f1; border-radius: 8px; text-align: center; font-family: Arial, sans-serif;'>
			<h3 style='color: #4CAF50;'>Remaining Hours</h3>
			<p style='font-size: 24px; color: #333; font-weight: bold;'>".calculate_remaining_hours($_POST['amc_id'])." hours</p>
		</div>";
		}
	}
	
	
   	
}
