<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Client extends CI_Controller {
	public function __construct()
    {
        parent::__construct();

        // $this->isAdminLoggedIn();
    }
    public function isAdminLoggedIn()
	{
        if($this->session->userdata('usertype') !== 'admin' && $this->session->userdata('usertype') !== 'staff')
        {
            redirect(base_url('dashboard'));
            exit;
        }
    }
	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	public function index()
    {
        $data['title'] = 'Client';
        $page = 'client/index';
        $this->header_and_footer($page, $data);
    }
	
  
	public function addClient()
    {
		$array = array(
			'fullname' => $_POST['fullname'],
			'mobile' => $_POST['mobile'],
			'email' => $_POST['email'],
			'website' => $_POST['website'],
			'address' => $_POST['address'],
		);
		
		if($this->model->add('client',$array))
		{  
			$lead_id = $this->db->insert_id();
			$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'add','client');
			echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
		} 
		
    }
	public function viewClient()
    {
		$data['list'] = $this->model->getResultData('client',[]);
		$this->load->view('client/tb',$data);
    }
	public function editClient()
    {
        $response=array();
		$data = $this->model->getRowData('client',['id' => $_POST['id']]);
		$response = array(
			'id' => $_POST['id'],
			'fullname' => $data['fullname'],
			'mobile' => $data['mobile'],
			'email' => $data['email'],
			'website' => $data['website'],
			'address' => $data['address'],
		);
		echo json_encode($response);
    }
	public function updateClient()
    {
		if(isset($_POST['id']))
		{
			$array = array(
				'fullname' => $_POST['fullname'],
				'mobile' => $_POST['mobile'],
				'email' => $_POST['email'],
				'website' => $_POST['website'],
				'address' => $_POST['address'],
			);
			
			if($this->model->edit('client',$array,['id'=>$_POST['id']]))
			{
				$lead_id = $_POST['id'];
				$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'edit','client');

				echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
			}
		}
	}
    public function detail()
    {
        $id=$this->uri->segment(2);
        $data['title'] = 'Client Detail';
		$data['data'] = $this->model->getRowData('client',['id'=>$id]);
        $page = 'client/detail';
        $this->header_and_footer($page, $data);
    }
	
   	
}
