<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Product extends CI_Controller {

	public function __construct()
    {
        parent::__construct();

        $this->isAdminLoggedIn();
    }

    public function isAdminLoggedIn(){
        if($this->session->userdata('usertype') !== 'admin')
        {
            redirect(base_url('dashboard'));
            exit;
        }
    }
	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	//Product Category management
	public function productCategory()
    {
        $data['title'] = 'Product Category';
        $page = 'product_category/index';
        $this->header_and_footer($page, $data);
    }
	public function addProductCategory()
    {
        if($_POST['category_name'])
		{
			$array = array(
				'category_name' => $_POST['category_name'],
			);
			if($this->product_model->addProductCategory($array))
			{
				echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
			}
		}
    }
	public function viewProductCategory()
    {
		$data['list'] = $this->model->getResultData('product_category',[]);
		$this->load->view('product_category/tb',$data);
    }
	public function editProductCategory()
    {
		$data = $this->model->getRowData('product_category',['id'=>$_POST['id']]);
		$response = array(
			'eid' => $_POST['id'],
			'category_name' => $data['category_name'],
			'category_photo' => base_url('assets/uploads/'.$data['category_photo'].''),
		);
		echo json_encode($response);
    }
	public function updateProductCategory()
    {
        if(isset($_POST['id']))
		{
			$array = array(
				'category_name' => $_POST['category_name'],
			);
			if($this->product_model->updateProductCategory($array,$_POST['id']))
			{
				echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
			}
		}
    }
	//Product Subcategory
	public function productSubCategory()
    {
        $data['title'] = 'Product SubCategory';
		$data['product_categories'] = $this->model->getResultData('product_category',['is_disable'=>0]);
        $page = 'product_subcategory/index';
        $this->header_and_footer($page, $data);
    }
	public function addProductSubCategory()
    {
        if($_POST['category_name'])
		{
			$array = array(
				'category_id' => $_POST['category_id'],
				'category_name' => $_POST['category_name'],
			);
			if($this->product_model->addProductSubCategory($array))
			{
				echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
			}
		}
    }
	public function viewProductSubCategory()
    {
		$data['list'] = $this->product_model->getProductSubCategoryResultData();
		$this->load->view('product_subcategory/tb',$data);
    }
	public function editProductSubCategory()
    {
		$data = $this->model->getRowData('product_subcategory',['id'=>$_POST['id']]);
		$response = array(
			'eid' => $_POST['id'],
			'category_id' => $data['category_id'],
			'category_name' => $data['category_name'],
			'category_photo' => base_url('assets/uploads/'.$data['category_photo'].''),
		);
		echo json_encode($response);
    }
	public function updateProductSubCategory()
    {
        if(isset($_POST['id']))
		{
			$array = array(
				'category_id' => $_POST['category_id'],
				'category_name' => $_POST['category_name'],
			);
			if($this->product_model->updateProductSubCategory($array,$_POST['id']))
			{
				echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
			}
		}
    }
	
}
