<div class="page-body">
          <div class="container-fluid">
            <div class="page-title">
              <div class="row">
                <div class="col-6">
                  <h3><?= $title; ?></h3>
                </div>
              </div>
            </div>
          </div>
          <!-- Container-fluid starts-->
          <div class="container-fluid">
            <div class="row">
              <div class="col-sm-12">
                <div class="card">
                  <div class="card-header">
                  <div class="row">
                  <div class="col-sm-6">
                    <h5><?= $title; ?></h5>
                  </div>
                  <div class="col-sm-6 text-right">
                    <button class="btn btn-success rounded add-btn" type="button" data-bs-toggle="modal" data-bs-target="#addQueryModal" data-bs-original-title="Add <?= $title; ?>"><i class="fa fa-plus"></i> Add <?= $title; ?></button>
                   </div>
                 </div>
                  </div>
                  <div class="card-body">
                    <div class="table-responsive" id="tb">
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <!-- Container-fluid Ends-->
        </div>
        <!-- Modal -->
        <div class="modal fade modal-bookmark" id="addQueryModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add <?= $title; ?></h5>
                <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
                <form class="form-bookmark" id="add-query-form">
                  <div class="row g-2">
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Staff</label>
                      <select name="staff_id" class="form-control" id="staff_id" <?php if($this->session->userdata('usertype') == 'staff'){ echo 'disabled';} ?> required>
                          <option value="">Select</option>
                          <?php foreach($staffs as $staff){ ?>
                            <option value="<?= $staff['id']; ?>" <?php if($this->session->userdata('usertype') == 'staff'){ echo ($this->session->userdata('id') == $staff['id']) ? "selected" : "";} ?>><?= $staff['fullname']; ?></option>
                          <?php } ?>
                      </select>                   
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Customer</label>
                      <select name="customer_id" class="form-control" id="customer_id" onchange="fetch_family(this.value)" required>
                          <option value="">Select</option>
                          <?php foreach($customers as $customer){ ?>
                            <option value="<?= $customer['id']; ?>" required><?= $customer['customer_name']; ?></option>
                          <?php } ?>
                      </select>                   
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Family Customer</label>
                      <select name="family_id" class="family form-control" id="family_id" required>
                      </select>                    
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Status</label>
                      <select name="status" class="form-control" id="status" required>
                        <option value="">Select</option>
                        <option value="Register">Register</option>
                        <option value="Inprogress">Inprogress</option>
                        <option value="Cancelled">Cancelled</option>
                        <option value="Completed">Completed</option>
                      </select>              
                    </div>
                    <div class="mb-3 mt-0 col-md-12">
                      <label for="bm-title">Description</label>
                      <textarea class="form-control" name="query_description"></textarea>                  
                    </div>
                  </div>
                  <button class="btn btn-secondary" type="submit">Add</button>
                  <button class="btn btn-primary" type="button" data-bs-dismiss="modal">Cancel</button>
                </form>
              </div>
            </div>
          </div>
        </div>

        <!-- Modal -->
        <div class="modal fade modal-bookmark" id="editQueryModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Edit Query</h5>
                <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
                <form class="form-bookmark" id="edit-query-form">
                  <div class="row g-2">
                  <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Staff</label>
                      <select name="staff_id" class="form-control" id="e_staff_id" required>
                          <option value="">Select</option>
                          <?php foreach($staffs as $staff){ ?>
                            <option value="<?= $staff['id']; ?>" <?php if($this->session->userdata('usertype') == 'staff'){ echo 'disabled';} ?>><?= $staff['fullname']; ?></option>
                          <?php } ?>
                      </select>                   
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Customer</label>
                      <select name="customer_id" class="form-control" id="e_customer_id" onchange="fetch_family(this.value)" required>
                          <option value="">Select</option>
                          <?php foreach($customers as $customer){ ?>
                            <option value="<?= $customer['id']; ?>" required><?= $customer['customer_name']; ?></option>
                          <?php } ?>
                      </select>                   
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Family Customer</label>
                      <select name="family_id" class="family form-control" id="e_family" required>
                      </select>                    
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Status</label>
                      <select name="status" class="form-control" id="e_status" required>
                        <option value="">Select</option>
                        <option value="Register">Register</option>
                        <option value="Inprogress">Inprogress</option>
                        <option value="Cancelled">Cancelled</option>
                        <option value="Completed">Completed</option>
                      </select>              
                    </div>
                    <div class="mb-3 mt-0 col-md-12">
                      <label for="bm-title">Description</label>
                      <textarea class="form-control" name="query_description" id="e_query_description"></textarea>                  
                    </div>
                  </div>
                  <input type="hidden" name="id" id="eid">
                  <button class="btn btn-secondary" type="submit">Update</button>
                  <button class="btn btn-primary" type="button" data-bs-dismiss="modal">Cancel</button>
                </form>
              </div>
            </div>
          </div>
        </div>

<script>
$(document).ready(function(){
  $.ajax({
      url: "<?= base_url('query/viewQuery'); ?>",
      method: "POST",
      data: '',
      success:function(res){
          $('#tb').html(res);
      }
  });
});
$("#add-query-form").submit(function(e){
  e.preventDefault();
  var formData = new FormData(this);
  $.ajax({
      url: "<?php echo base_url('query/addQuery'); ?>",
      method: "POST",
      data:  formData,
      cache: false,
      contentType: false,
      processData: false,
      dataType:'json',
      success:function(res){
        if(res.return)
        {
          $('#addQueryModal').modal('toggle'); 
          $('#add-query-form')[0].reset();
          $('#tb').load('<?= base_url('query/viewQuery'); ?>');
          toastr.success(res.msg);
        }
        else
        {
          toastr.error(res.msg);
        }
      }
  });
});
function editQuery(id)
{
  $.ajax({
      url: "<?php echo base_url('query/editQuery'); ?>",
      method: "POST",
      data: {
          id:id
      },
      dataType: 'json',
      success:function(res){
        fetch_family(res.customer_id,res.family_id);
        $("#eid").val(res.eid);
        $("#e_staff_id option[value='"+res.staff_id+"']").attr("selected", "selected");
        $("#e_customer_id option[value='"+res.customer_id+"']").attr("selected", "selected");
        $("#e_query_description").val(res.query_description);
        $("#e_status option[value='"+res.status+"']").attr("selected", "selected");
      }
  });
};
$("#edit-query-form").submit(function(e){
  e.preventDefault();
  var formData = new FormData(this);
  $.ajax({
      url: "<?php echo base_url('query/updateQuery'); ?>",
      method: "POST",
      data:  formData,
      cache: false,
      contentType: false,
      processData: false,
      dataType:'json',
      success:function(res){
        if(res.return)
        {
          $('#editQueryModal').modal('toggle'); 
          $('#tb').load('<?= base_url('query/viewQuery'); ?>');
          toastr.success(res.msg);
        }
        else
        {
          toastr.error(res.msg);
        }
      }
  });
});
function fetch_family(customer_id,family_id) {
    $.ajax({
      url: "<?= base_url('dashboard/fetch_family'); ?>",
      method: "POST",
      data: {
        customer_id: customer_id,
        family_id: family_id,
      },
      success: function(data) {
        if(family_id == null)
        {
          $(".family").html(data);
        }
        else
        {
          $("#e_family").html(data);
        }
      },
    });
  }
</script>