<div class="page-body">
          <div class="container-fluid">
            <div class="page-title">
              <div class="row">
                <div class="col-6">
                  <h3><?= $title; ?></h3>
                </div>
              </div>
            </div>
          </div>
          <!-- Container-fluid starts-->
          <div class="container-fluid">
            <div class="row">
              <div class="col-sm-12">
                <div class="card">
                  <div class="card-header">
                  <div class="row">
                  <div class="col-sm-6">
                    <h5><?= $title; ?></h5>
                  </div>
                  <div class="col-sm-6 text-right">
                    <button class="btn btn-success rounded add-btn" type="button" data-bs-toggle="modal" data-bs-target="#addOrderModal" data-bs-original-title="Add <?= $title; ?>"><i class="fa fa-plus"></i> Add <?= $title; ?></button>
                   </div>
                 </div>
                  </div>
                  <div class="card-body">
                    <div class="table-responsive" id="tb">
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <!-- Container-fluid Ends-->
        </div>
        <!-- Modal -->
        <div class="modal fade modal-bookmark" id="addOrderModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add <?= $title; ?></h5>
                <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
                <form class="form-bookmark" id="add-order-form">
                  <div class="row g-2">
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Oder ID</label>
                      <input class="form-control" type="text" name="order_id" id="order_id"
                      value="<?= $orderId ?>" readonly
                      required="">
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Product Category</label>
                      <select name="category_id" class="form-control" id="category_id" onchange="fetch_subcategory(this.value)" required>
                          <option value="">Select</option>
                          <?php foreach($categories as $category){ ?>
                            <option value="<?= $category['id']; ?>" required><?= $category['category_name']; ?></option>
                          <?php } ?>
                      </select>                   
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Subcategory</label>
                      <select name="subcategory_id" class="subcategory form-control" id="subcategory_id" required>
                      </select>                    
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Customer</label>
                      <select name="customer_id" class="form-control" id="customer_id" onchange="fetch_family(this.value)" required>
                          <option value="">Select</option>
                          <?php foreach($customers as $customer){ ?>
                            <option value="<?= $customer['id']; ?>" required><?= $customer['customer_name']; ?></option>
                          <?php } ?>
                      </select>                   
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Family Customer</label>
                      <select name="family_id" class="family form-control" id="family_id" required>
                      </select>                    
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Company</label>
                      <select name="company_id" class="form-control" id="company_id" required>
                        <option value="">Select</option>
                        <?php foreach($companies as $company){ ?>
                          <option value="<?= $company['id']; ?>" required><?= $company['company_name']; ?></option>
                        <?php } ?>
                      </select>              
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Sum Assured</label>
                      <input class="form-control" type="number" name="sum_assured">               
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Premium Amount</label>
                      <input class="form-control" type="number" name="premium_amount">               
                    </div>
                    <div class="mb-3 mt-0 col-md-12">
                      <label for="bm-title">Description</label>
                      <textarea class="form-control" name="description"></textarea>                  
                    </div>
                  </div>
                  <button class="btn btn-secondary" type="submit">Add</button>
                  <button class="btn btn-primary" type="button" data-bs-dismiss="modal">Cancel</button>
                </form>
              </div>
            </div>
          </div>
        </div>

        <!-- Modal -->
        <div class="modal fade modal-bookmark" id="editOrderModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Edit Order</h5>
                <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
                <form class="form-bookmark" id="edit-order-form">
                  <div class="row g-2">
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Oder ID</label>
                      <input class="form-control" type="text" name="order_id" id="e_order_id" readonly required="">
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Product Category</label>
                      <select name="category_id" class="form-control" id="e_category_id" onchange="fetch_subcategory(this.value)" required>
                          <option value="">Select</option>
                          <?php foreach($categories as $category){ ?>
                            <option value="<?= $category['id']; ?>" required><?= $category['category_name']; ?></option>
                          <?php } ?>
                      </select>                   
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Subcategory</label>
                      <select name="subcategory_id" class="subcategory form-control" id="e_subcategory_id" required>
                      </select>                    
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Customer</label>
                      <select name="customer_id" class="form-control" id="e_customer_id" onchange="fetch_family(this.value)" required>
                          <option value="">Select</option>
                          <?php foreach($customers as $customer){ ?>
                            <option value="<?= $customer['id']; ?>" required><?= $customer['customer_name']; ?></option>
                          <?php } ?>
                      </select>                   
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Family Customer</label>
                      <select name="family_id" class="family form-control" id="e_family_id" required>
                      </select>                    
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Company</label>
                      <select name="company_id" class="form-control" id="e_company_id" required>
                        <option value="">Select</option>
                        <?php foreach($companies as $company){ ?>
                          <option value="<?= $company['id']; ?>" required><?= $company['company_name']; ?></option>
                        <?php } ?>
                      </select>              
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Sum Assured</label>
                      <input class="form-control" type="number" name="sum_assured" id="e_sum_assured">               
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Premium Amount</label>
                      <input class="form-control" type="number" name="premium_amount" id="e_premium_amount">               
                    </div>
                    <div class="mb-3 mt-0 col-md-12">
                      <label for="bm-title">Description</label>
                      <textarea class="form-control" name="description" id="e_description"></textarea>                  
                    </div>
                  </div>
                  <input type="hidden" name="id" id="eid">
                  <button class="btn btn-secondary" type="submit">Update</button>
                  <button class="btn btn-primary" type="button" data-bs-dismiss="modal">Cancel</button>
                </form>
              </div>
            </div>
          </div>
        </div>

<script>
$(document).ready(function(){
  $.ajax({
      url: "<?= base_url('order/viewOrder'); ?>",
      method: "POST",
      data: '',
      success:function(res){
          $('#tb').html(res);
      }
  });
});
$("#add-order-form").submit(function(e){
  e.preventDefault();
  var formData = new FormData(this);
  $.ajax({
      url: "<?php echo base_url('order/addOrder'); ?>",
      method: "POST",
      data:  formData,
      cache: false,
      contentType: false,
      processData: false,
      dataType:'json',
      success:function(res){
        if(res.return)
        {
          $('#addOrderModal').modal('toggle'); 
          $('#add-order-form')[0].reset();
          $('#tb').load('<?= base_url('order/viewOrder'); ?>');
          $('#order_id').val(res.order_id);
          toastr.success(res.msg);
        }
        else
        {
          toastr.error(res.msg);
        }
      }
  });
});
function editOrder(id)
{
  $.ajax({
      url: "<?php echo base_url('order/editOrder'); ?>",
      method: "POST",
      data: {
          id:id
      },
      dataType: 'json',
      success:function(res){
        fetch_family(res.customer_id,res.family_id);
        fetch_subcategory(res.category_id,res.subcategory_id);
        $("#eid").val(res.eid);
        $("#e_order_id").val(res.order_id);
        $("#e_staff_id option[value='"+res.staff_id+"']").attr("selected", "selected");
        $("#e_customer_id option[value='"+res.customer_id+"']").attr("selected", "selected");
        $("#e_category_id option[value='"+res.category_id+"']").attr("selected", "selected");
        $("#e_description").val(res.description);
        $("#e_sum_assured").val(res.sum_assured);
        $("#e_premium_amount").val(res.premium_amount);
        $("#e_company_id option[value='"+res.company_id+"']").attr("selected", "selected");
      }
  });
};
$("#edit-order-form").submit(function(e){
  e.preventDefault();
  var formData = new FormData(this);
  $.ajax({
      url: "<?php echo base_url('order/updateOrder'); ?>",
      method: "POST",
      data:  formData,
      cache: false,
      contentType: false,
      processData: false,
      dataType:'json',
      success:function(res){
        if(res.return)
        {
          $('#editOrderModal').modal('toggle'); 
          $('#tb').load('<?= base_url('order/viewOrder'); ?>');
          toastr.success(res.msg);
        }
        else
        {
          toastr.error(res.msg);
        }
      }
  });
});
function fetch_family(customer_id,family_id) {
  $.ajax({
    url: "<?= base_url('dashboard/fetch_family'); ?>",
    method: "POST",
    data: {
      customer_id: customer_id,
      family_id: family_id,
    },
    success: function(data) {
      if(family_id == null)
      {
        $(".family").html(data);
      }
      else
      {
        $("#e_family_id").html(data);
      }
    },
  });
}
function fetch_subcategory(category_id,subcategory_id) {
  $.ajax({
    url: "<?= base_url('dashboard/fetch_subcategory'); ?>",
    method: "POST",
    data: {
      category_id: category_id,
      subcategory_id: subcategory_id,
    },
    success: function(data) {
      if(subcategory_id == null)
      {
        $(".subcategory").html(data);
      }
      else
      {
        $("#e_subcategory_id").html(data);
      }
    },
  });
}
</script>