<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Staff extends CI_Controller {

	public function __construct()
    {
        parent::__construct();

        $this->isAdminLoggedIn();
    }

    public function isAdminLoggedIn(){
        if($this->session->userdata('usertype') !== 'admin')
        {
            redirect(base_url('dashboard'));
            exit;
        }
    }

	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	public function index()
    {
        $data['title'] = 'Staff';
        $page = 'staff/index';
        $this->header_and_footer($page, $data);
    }
	public function addStaff()
    {
		$countEmail = $this->model->countData('staff',['emailid'=>$_POST['emailid']]);
		if($countEmail > 0 )
		{
			echo json_encode(['return'=>false,'msg'=>'Email already exist']);
		}
		else
		{
			if($_POST['fullname'])
			{
				$array = array(
					'fullname' => ucfirst($_POST['fullname']),
					'emailid' => $_POST['emailid'],
					'password' =>md5($_POST['password']),
					'mobile' =>  $_POST['mobile'],
				);
				if($this->model->add('staff',$array))
				{
					echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
				}
				
			}
		}
    }
	public function viewStaff()
    {
		$data['list'] = $this->model->getResultData('staff',[]);
		$this->load->view('staff/tb',$data);
    }
	public function editStaff()
    {
        $response=array();
		$data = $this->model->getRowData('staff',['id' => $_POST['id']]);
		if($data['mobile'] !== '')
		{
			$mob = explode(' ',$data['mobile']);
			$ccode = $mob[0];
			$contact = $mob[1];
		}else{
			$mob = '';
			$ccode = '';
			$contact = '';
		}
		$response = array(
			'id' => $_POST['id'],
			'fullname' => $data['fullname'],
			'email' => $data['emailid'],
			'mobile' => $contact,
			'ccode' => str_replace("+","",$ccode),
		);
		echo json_encode($response);
    }
	public function updateStaff()
    {
		$countEmail = $this->model->countData('staff',['emailid'=>$_POST['emailid'],'id!='=>$_POST['id']]);
		if($countEmail > 0 )
		{
			echo json_encode(['return'=>false,'msg'=>'Email already exist']);
		}
		else
		{
			if(isset($_POST['id']))
			{
				$array = array(
					'fullname' => ucfirst($_POST['fullname']),
					'emailid' => $_POST['emailid'],
					'mobile' =>  $_POST['mobile'],
				);
				if($this->model->edit('staff',$array,['id' => $_POST['id']]))
				{
					echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
				}
			}
			else
			{
				echo json_encode(['return'=>false,'msg'=>'`id` is required']);
			}
		}
    }
  
    public function detail()
    {
        $id=$this->uri->segment(2);
        $data['title'] = 'Staff Detail';
		$data['data'] = $this->staff_model->getStaffRowData($id);
        $page = 'staff/detail';
        $this->header_and_footer($page, $data);
    }
    public function changePassword()
    {
        if($_POST['id'])
		{
			if($this->model->edit('staff',['password'=>md5($_POST['password'])],['id' => $_POST['id']]))
			{
				$this->viewStaff();
			}
			
		}
    }
	
}
