<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Order extends CI_Controller {

	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	
	public function index()
    {
        $data['title'] = 'Order';
		if($this->model->countData('order',[]) > 0){
		$number = $this->model->getRowData('order',[],null,'id','DESC')['id'] + 1;
		$number = sprintf('%03d',$number);
		$data['orderId'] = 'RO'.$number;
		}else{
			$data['orderId'] = 'RO'.sprintf('%03d',1);
		}
		$data['categories'] = $this->model->getResultData('product_category',['is_disable'=>0]);
		$data['customers'] = $this->model->getResultData('primary_customer',['is_suspended'=>0]);
		$data['companies'] = $this->model->getResultData('company',['is_disable'=>0]);
        $page = 'order/index';
        $this->header_and_footer($page, $data);
    }
	public function addOrder()
    {
        if($_POST['category_id'])
		{
			$array = array(
				'order_id' => $_POST['order_id'],
				'category_id' => $_POST['category_id'],
				'subcategory_id' => $_POST['subcategory_id'],
				'description' => $_POST['description'],
				'customer_id' => $_POST['customer_id'],
				'family_id' => $_POST['family_id'],
				'sum_assured' => $_POST['sum_assured'],
				'premium_amount' => $_POST['premium_amount'],
				'company_id' => $_POST['company_id'],
			);
			if($this->model->add('order',$array))
			{				
				if($this->model->countData('order',[]) > 0){
					$number = $this->model->getRowData('order',[],null,'id','DESC')['id'] + 1;
					$number = sprintf('%03d',$number);
					$data['orderId'] = 'RO'.$number;
					}else{
						$data['orderId'] = 'RO'.sprintf('%03d',1);
					}
				echo json_encode(['return'=>true,'msg'=>'Added Successfully','order_id'=>$data['orderId']]);
			}
		}
    }
	public function viewOrder()
    {		
		$data['list'] = $this->order_model->getOrderResultData();
		$this->load->view('order/tb',$data);
    }
	public function editOrder()
    {
		$data = $this->model->getRowData('order',['id'=>$_POST['id']]);
		$response = array(
			'eid' => $_POST['id'],
			'order_id' => $data['order_id'],
			'category_id' => $data['category_id'],
			'subcategory_id' => $data['subcategory_id'],
			'description' => $data['description'],
			'customer_id' => $data['customer_id'],
			'family_id' => $data['family_id'],
			'sum_assured' => $data['sum_assured'],
			'premium_amount' => $data['premium_amount'],
			'company_id' => $data['company_id'],
		);
		echo json_encode($response);
    }
	public function updateOrder()
    {
        if(isset($_POST['id']))
		{
			$array = array(
				'order_id' => $_POST['order_id'],
				'category_id' => $_POST['category_id'],
				'subcategory_id' => $_POST['subcategory_id'],
				'description' => $_POST['description'],
				'customer_id' => $_POST['customer_id'],
				'family_id' => $_POST['family_id'],
				'sum_assured' => $_POST['sum_assured'],
				'premium_amount' => $_POST['premium_amount'],
				'company_id' => $_POST['company_id'],
			);
			if($this->model->edit('order',$array,['id'=>$_POST['id']]))
			{
				echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
			}
		}
    }
	public function orderDetail()
    {
        $id=$this->uri->segment(2);
        $data['title'] = 'Order Detail';
		$data['data'] = $this->order_model->getOrderRowData($id);
        $page = 'order/detail';
        $this->header_and_footer($page, $data);
    }	
	
}
