<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require 'vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
class Dashboard extends CI_Controller {

	// public function __construct()
    // {
    //     parent::__construct();

    //     $this->isLoggedIn();
    // }

    // public function isLoggedIn(){
    //     $is_logged_in = $this->session->userdata('logged_in');
    //     if(!isset($is_logged_in) || $is_logged_in!==TRUE)
    //     {
    //         redirect(base_url());
    //         exit;
    //     }
    // }
	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	public function index()
    {
        $data['title'] = 'Dashboard';
		$data['total_staff'] = $this->model->countData('staff',[]);
		$data['total_customer'] = $this->model->countData('primary_customer',[]);
		$data['total_family'] = $this->model->countData('family_customer',[]);
		$data['total_orders'] = $this->model->countData('order',[]);
		$data['total_company'] = $this->model->countData('company',[]);
		$data['pending_queries'] = $this->model->countData('query',['status!='=>'Completed']);
		$data['pending_query_list'] = $this->query_model->getQueryResultData(['t1.status!='=>'Completed']);
        $page = 'dashboard';
        $this->header_and_footer($page, $data);
    }
	public function logout(){
		$this->session->unset_userdata(array('logged_in','email','usertype','id'));
		redirect(base_url('admin'));
	}
	function multipleDel()
    {
		$this->multipleDelete();
    }
    function Status()
    {
		$this->changeStatus();
    }
    public function fetch_state()
    {
        if ($this->input->post('country_id')) {
            $cid = $this->input->post('country_id');
            $this->model->fetch_state($cid,$this->input->post('state_id'));
        }
    }
    public function fetch_city()
    {
        if ($this->input->post('state_id')) {
            $sid = $this->input->post('state_id');
            $this->model->fetch_city($sid,$this->input->post('city_id'));
        }
    }
    public function fetch_family()
    {
        if ($this->input->post('customer_id')) {
            $cid = $this->input->post('customer_id');
            $this->model->fetch_family($cid,$this->input->post('family_id'));
        }
    }
    public function fetch_subcategory()
    {
        if ($this->input->post('category_id')) {
            $cid = $this->input->post('category_id');
            $this->model->fetch_subcategory($cid,$this->input->post('subcategory_id'));
        }
    }
    public function importMF()
    {
		// $arr_file = explode('.', $_FILES['file']['name']);
        //     $extension = end($arr_file);
        //     if('csv' == $extension){
        //         $reader = new \PhpOffice\PhpSpreadsheet\Reader\Csv();
        //     }elseif('xls' == $extension){
        //         $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xls();
        //     }else {
        //         $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
        //     }
        //     $spreadsheet = $reader->load($_FILES['file']['tmp_name']);
        //     $sheetData = $spreadsheet->getActiveSheet()->toArray();
        //     echo "<pre>";
        //     print_r($sheetData);
		// 	die('A');
		ini_set('max_execution_time', 0);
		ini_set('memory_limit','-1');
        if(isset($_FILES["file"]["name"]))
		{
			$path = $_FILES["file"]["tmp_name"];
			$object = PHPExcel_IOFactory::load($path);
            //Import primary customer
			$pcusArr = array();
			$fcusArr = array();
			
			// foreach($object->getWorksheetIterator() as $worksheet)
			// {
				$worksheet = $object->getActiveSheet();
				$highestRow = $worksheet->getHighestRow();
				$highestColumn = $worksheet->getHighestColumn();
				for($row=2; $row<=$highestRow; $row++)
				{
					$primaryCustomers = $this->model->getResultData('primary_customer',['is_suspended'=>0]);
					foreach($primaryCustomers as $pcus)
					{
						array_push($pcusArr,strtolower($pcus['customer_name']));

					}
					$familyCustomers = $this->model->getResultData('family_customer',['is_suspended'=>0]);
					foreach($familyCustomers as $fcus)
					{
						array_push($fcusArr,strtolower($fcus['customer_name']));

					}
					$customer_name = $worksheet->getCellByColumnAndRow(0, $row)->getValue();
					$family_customer_name = $worksheet->getCellByColumnAndRow(1, $row)->getValue();
					$address = $worksheet->getCellByColumnAndRow(2, $row)->getValue();
					$address2 = $worksheet->getCellByColumnAndRow(3, $row)->getValue();
					$address3 = $worksheet->getCellByColumnAndRow(4, $row)->getValue();
					$city_name = $worksheet->getCellByColumnAndRow(5, $row)->getValue();
					$state_name = $worksheet->getCellByColumnAndRow(6, $row)->getValue();
					$pincode = $worksheet->getCellByColumnAndRow(7, $row)->getValue();
					$divopt = $worksheet->getCellByColumnAndRow(8, $row)->getValue();
					$customer_mobileno = $worksheet->getCellByColumnAndRow(10, $row)->getValue();
					$occupation = $worksheet->getCellByColumnAndRow(11, $row)->getValue();
					$customer_emailid = $worksheet->getCellByColumnAndRow(12, $row)->getValue();
					$birthdate = date('d-m-Y',PHPExcel_Shared_Date::ExcelToPHP($worksheet->getCellByColumnAndRow(13, $row)->getValue()));
					// $city = '';$state = '';
					// if(isset($city_name)){
					// 	$city_data = $this->model->getRowData('cities',['name'=>$city_name]);
					// 	if($city_data){
					// 		$city = $city_data['id'];
					// 		$state = $city_data['state_id'];
					// 	}
					// }
					if (!in_array(strtolower($customer_name), $pcusArr))
					{
						$data = array(
							'customer_name'  => $customer_name,
							'address'  => $address,
							'address2'  => $address2,
							'address3'  => $address3,
							'city'  => $city_name,
							'state'  => $state_name,
							'pincode'  => $pincode,
							'divopt'  => $divopt,
							'customer_mobileno'  => $customer_mobileno,
							'customer_emailid'  => $customer_emailid,
							'occupation'  => $occupation,
							'birthdate'  => $birthdate,
							'type'  => 'Mutual fund',
						);
						// echo "<pre>";print_r($data);
						$this->db->insert('primary_customer', $data);
					}
					if (!in_array(strtolower($family_customer_name), $fcusArr))
					{
						$family_data = array(
							'primary_customer'  => $customer_name,
							'customer_name'  => $family_customer_name,
							'customer_mobileno'  => $customer_mobileno,
							'customer_emailid'  => $customer_emailid,
							'occupation'  => $occupation,
							'birthdate'  => $birthdate,
						);
						$this->db->insert('family_customer', $family_data);
					}
					// else
					// {
					// 	$data[] = array();
					// }
				}
			// }
			// if(!empty($data))
			// {
			//     $this->db->insert_batch('primary_customer', $data);
			// }
			// $this->viewFamilyCustomer();
		}
    }
	//Import Motor Insurance
	public function importMotorInsurance()
    {
        if(isset($_FILES["file"]["name"]))
		{
			$path = $_FILES["file"]["tmp_name"];
			$object = PHPExcel_IOFactory::load($path);
            //Import primary customer
			$pcusArr = array();
			
			// foreach($object->getWorksheetIterator() as $worksheet)
			// {
				$worksheet = $object->getActiveSheet();
				$highestRow = $worksheet->getHighestRow();
				$highestColumn = $worksheet->getHighestRow();
				
				for($row=2; $row<=$highestRow; $row++)
				{
					if($worksheet->getCellByColumnAndRow(1, $row)->getValue()){
						$policy_date_to = date('d-m-Y',PHPExcel_Shared_Date::ExcelToPHP($worksheet->getCellByColumnAndRow(1, $row)->getValue()));
					}else{
						$policy_date_to = '';
					}
					if($worksheet->getCellByColumnAndRow(2, $row)->getValue()){
						$policy_date_till = date('d-m-Y',PHPExcel_Shared_Date::ExcelToPHP($worksheet->getCellByColumnAndRow(2, $row)->getValue()));
					}else{
						$policy_date_till = '';
					}
					$customer_name = $worksheet->getCellByColumnAndRow(3, $row)->getValue();
					$model = $worksheet->getCellByColumnAndRow(4, $row)->getValue();
					$policy_number = $worksheet->getCellByColumnAndRow(5, $row)->getValue();
					$company_name = $worksheet->getCellByColumnAndRow(6, $row)->getValue();
					$provider = $worksheet->getCellByColumnAndRow(7, $row)->getValue();
					$policy_type = $worksheet->getCellByColumnAndRow(8, $row)->getValue();
					$sum_assured = $worksheet->getCellByColumnAndRow(9, $row)->getValue();
					$amount = $worksheet->getCellByColumnAndRow(10, $row)->getValue();
					$data = array(
						'policy_date_to'  => $policy_date_to,
						'policy_date_till'  => $policy_date_till,
						'customer_name'  => $customer_name,
						'model'  => $model,
						'policy_number'  => $policy_number,
						'company_name'  => $company_name,
						'provider'  => $provider,
						'policy_type'  => $policy_type,
						'sum_assured'  => $sum_assured,
						'amount'  => $amount,
						'type'  => 'Motor Insurance',
					);
					$primaryData = $this->model->getRowData('primary_customer',['customer_name'=>$customer_name]);
					$familyData = $this->model->getRowData('family_customer',['customer_name'=>$customer_name]);
					if($primaryData){
						$data['address'] = $primaryData['address'];
						$data['address2'] = $primaryData['address2'];
						$data['address3'] = $primaryData['address3'];
						$data['city'] = $primaryData['city'];
						$data['state'] = $primaryData['state'];
						$data['pincode'] = $primaryData['pincode'];
						$data['divopt'] = $primaryData['divopt'];
						$data['customer_mobileno'] = $primaryData['customer_mobileno'];
						$data['occupation'] = $primaryData['occupation'];
						$data['customer_emailid'] = $primaryData['customer_emailid'];
						$data['birthdate'] = $primaryData['birthdate'];
					}else if($familyData){
						$primaryCusData = $this->model->getRowData('primary_customer',['customer_name'=>$familyData['primary_customer']]);
						$data['address'] = $primaryCusData['address'];
						$data['address2'] = $primaryCusData['address2'];
						$data['address3'] = $primaryCusData['address3'];
						$data['city'] = $primaryCusData['city'];
						$data['state'] = $primaryCusData['state'];
						$data['pincode'] = $primaryCusData['pincode'];
						$data['divopt'] = $primaryCusData['divopt'];
						$data['customer_mobileno'] = $familyData['customer_mobileno'];
						$data['occupation'] = $familyData['occupation'];
						$data['customer_emailid'] = $familyData['customer_emailid'];
						$data['birthdate'] = $familyData['birthdate'];
					}
					$this->db->insert('primary_customer', $data);
				}
			// }
		}
    }
	//Import General Insurance
	public function importGeneralInsurance()
    {
        if(isset($_FILES["file"]["name"]))
		{
			$path = $_FILES["file"]["tmp_name"];
			$object = PHPExcel_IOFactory::load($path);
            //Import primary customer
			$pcusArr = array();
			
			// foreach($object->getWorksheetIterator() as $worksheet)
			// {
				$worksheet = $object->getActiveSheet();
				$highestRow = $worksheet->getHighestRow();
				$highestColumn = $worksheet->getHighestRow();
				for($row=3; $row<=$highestRow; $row++)
				{
					if($worksheet->getCellByColumnAndRow(1, $row)->getValue()){
						$policy_date_to = date('d-m-Y',PHPExcel_Shared_Date::ExcelToPHP($worksheet->getCellByColumnAndRow(1, $row)->getValue()));
					}else{
						$policy_date_to = '';
					}
					if($worksheet->getCellByColumnAndRow(2, $row)->getValue()){
						$policy_date_till = date('d-m-Y',PHPExcel_Shared_Date::ExcelToPHP($worksheet->getCellByColumnAndRow(2, $row)->getValue()));
					}else{
						$policy_date_till = '';
					}
					$customer_name = $worksheet->getCellByColumnAndRow(3, $row)->getValue();
					$model = $worksheet->getCellByColumnAndRow(4, $row)->getValue();
					$policy_number = $worksheet->getCellByColumnAndRow(5, $row)->getValue();
					$company_name = $worksheet->getCellByColumnAndRow(6, $row)->getValue();
					$provider = $worksheet->getCellByColumnAndRow(7, $row)->getValue();
					$policy_type = $worksheet->getCellByColumnAndRow(8, $row)->getValue();
					$sum_assured = $worksheet->getCellByColumnAndRow(9, $row)->getValue();
					$amount = $worksheet->getCellByColumnAndRow(10, $row)->getValue();


					$data = array(
						'policy_date_to'  => $policy_date_to,
						'policy_date_till'  => $policy_date_till,
						'customer_name'  => $customer_name,
						'model'  => $model,
						'policy_number'  => $policy_number,
						'company_name'  => $company_name,
						'provider'  => $provider,
						'policy_type'  => $policy_type,
						'sum_assured'  => $sum_assured,
						'amount'  => $amount,
						'type'  => 'General Insurance',
					);

					$primaryData = $this->model->getRowData('primary_customer',['customer_name'=>$customer_name]);
					$familyData = $this->model->getRowData('family_customer',['customer_name'=>$customer_name]);
					if($primaryData){
						$data['address'] = $primaryData['address'];
						$data['address2'] = $primaryData['address2'];
						$data['address3'] = $primaryData['address3'];
						$data['city'] = $primaryData['city'];
						$data['state'] = $primaryData['state'];
						$data['pincode'] = $primaryData['pincode'];
						$data['divopt'] = $primaryData['divopt'];
						$data['customer_mobileno'] = $primaryData['customer_mobileno'];
						$data['occupation'] = $primaryData['occupation'];
						$data['customer_emailid'] = $primaryData['customer_emailid'];
						$data['birthdate'] = $primaryData['birthdate'];
					}else if($familyData){
						$primaryCusData = $this->model->getRowData('primary_customer',['customer_name'=>$familyData['primary_customer']]);
						$data['address'] = $primaryCusData['address'];
						$data['address2'] = $primaryCusData['address2'];
						$data['address3'] = $primaryCusData['address3'];
						$data['city'] = $primaryCusData['city'];
						$data['state'] = $primaryCusData['state'];
						$data['pincode'] = $primaryCusData['pincode'];
						$data['divopt'] = $primaryCusData['divopt'];
						$data['customer_mobileno'] = $familyData['customer_mobileno'];
						$data['occupation'] = $familyData['occupation'];
						$data['customer_emailid'] = $familyData['customer_emailid'];
						$data['birthdate'] = $familyData['birthdate'];
					}
					$this->db->insert('primary_customer', $data);
				}
			// }
		}
    }
	//Import Hdfc
	public function importHdfc()
    {
        if(isset($_FILES["file"]["name"]))
		{
			$path = $_FILES["file"]["tmp_name"];
			$object = PHPExcel_IOFactory::load($path);
            //Import primary customer
			$pcusArr = array();
			
			// foreach($object->getWorksheetIterator() as $worksheet)
			// {
				$worksheet = $object->getActiveSheet();
				$highestRow = $worksheet->getHighestRow();
				$highestColumn = $worksheet->getHighestRow();
				for($row=3; $row<=$highestRow; $row++)
				{
					$policy_date_to = date('d-m-Y',PHPExcel_Shared_Date::ExcelToPHP($worksheet->getCellByColumnAndRow(1, $row)->getValue()));
					$policy_date_till = date('d-m-Y',PHPExcel_Shared_Date::ExcelToPHP($worksheet->getCellByColumnAndRow(2, $row)->getValue()));
					$customer_name = $worksheet->getCellByColumnAndRow(3, $row)->getValue();
					$model = $worksheet->getCellByColumnAndRow(4, $row)->getValue();
					$policy_number = $worksheet->getCellByColumnAndRow(5, $row)->getValue();
					$company_name = $worksheet->getCellByColumnAndRow(6, $row)->getValue();
					$provider = $worksheet->getCellByColumnAndRow(7, $row)->getValue();
					$policy_type = $worksheet->getCellByColumnAndRow(8, $row)->getValue();
					$sum_assured = $worksheet->getCellByColumnAndRow(9, $row)->getValue();
					$amount = $worksheet->getCellByColumnAndRow(10, $row)->getValue();
					$data = array(
						'policy_date_to'  => $policy_date_to,
						'policy_date_till'  => $policy_date_till,
						'customer_name'  => $customer_name,
						'model'  => $model,
						'policy_number'  => $policy_number,
						'company_name'  => $company_name,
						'provider'  => $provider,
						'policy_type'  => $policy_type,
						'sum_assured'  => $sum_assured,
						'amount'  => $amount,
						'type'  => 'Hdfc',
					);
					$primaryData = $this->model->getRowData('primary_customer',['customer_name'=>$customer_name]);
					$familyData = $this->model->getRowData('family_customer',['customer_name'=>$customer_name]);
					if($primaryData){
						$data['address'] = $primaryData['address'];
						$data['address2'] = $primaryData['address2'];
						$data['address3'] = $primaryData['address3'];
						$data['city'] = $primaryData['city'];
						$data['state'] = $primaryData['state'];
						$data['pincode'] = $primaryData['pincode'];
						$data['divopt'] = $primaryData['divopt'];
						$data['customer_mobileno'] = $primaryData['customer_mobileno'];
						$data['occupation'] = $primaryData['occupation'];
						$data['customer_emailid'] = $primaryData['customer_emailid'];
						$data['birthdate'] = $primaryData['birthdate'];
					}else if($familyData){
						$primaryCusData = $this->model->getRowData('primary_customer',['customer_name'=>$familyData['primary_customer']]);
						$data['address'] = $primaryCusData['address'];
						$data['address2'] = $primaryCusData['address2'];
						$data['address3'] = $primaryCusData['address3'];
						$data['city'] = $primaryCusData['city'];
						$data['state'] = $primaryCusData['state'];
						$data['pincode'] = $primaryCusData['pincode'];
						$data['divopt'] = $primaryCusData['divopt'];
						$data['customer_mobileno'] = $familyData['customer_mobileno'];
						$data['occupation'] = $familyData['occupation'];
						$data['customer_emailid'] = $familyData['customer_emailid'];
						$data['birthdate'] = $familyData['birthdate'];
					}
					if(isset($policy_date_to))
					{
						$this->db->insert('primary_customer', $data);
					}
				}
			// }
		}
    }
	//Import Bajaj
	public function importBajaj()
    {
        if(isset($_FILES["file"]["name"]))
		{
			$path = $_FILES["file"]["tmp_name"];
			$object = PHPExcel_IOFactory::load($path);
            //Import primary customer
			$pcusArr = array();
			
			// foreach($object->getWorksheetIterator() as $worksheet)
			// {
				$worksheet = $object->getActiveSheet();
				$highestRow = $worksheet->getHighestRow();
				$highestColumn = $worksheet->getHighestRow();
				for($row=3; $row<=$highestRow; $row++)
				{
					$policy_date_to = date('d-m-Y',PHPExcel_Shared_Date::ExcelToPHP($worksheet->getCellByColumnAndRow(1, $row)->getValue()));
					$policy_date_till = date('d-m-Y',PHPExcel_Shared_Date::ExcelToPHP($worksheet->getCellByColumnAndRow(2, $row)->getValue()));
					$customer_name = $worksheet->getCellByColumnAndRow(3, $row)->getValue();
					$model = $worksheet->getCellByColumnAndRow(4, $row)->getValue();
					$policy_number = $worksheet->getCellByColumnAndRow(5, $row)->getValue();
					$company_name = $worksheet->getCellByColumnAndRow(6, $row)->getValue();
					$provider = $worksheet->getCellByColumnAndRow(7, $row)->getValue();
					$policy_type = $worksheet->getCellByColumnAndRow(8, $row)->getValue();
					$sum_assured = $worksheet->getCellByColumnAndRow(9, $row)->getValue();
					$amount = $worksheet->getCellByColumnAndRow(10, $row)->getValue();
					$data = array(
						'policy_date_to'  => $policy_date_to,
						'policy_date_till'  => $policy_date_till,
						'customer_name'  => $customer_name,
						'model'  => $model,
						'policy_number'  => $policy_number,
						'company_name'  => $company_name,
						'provider'  => $provider,
						'policy_type'  => $policy_type,
						'sum_assured'  => $sum_assured,
						'amount'  => $amount,
						'type'  => 'Bajaj',
					);
					$primaryData = $this->model->getRowData('primary_customer',['customer_name'=>$customer_name]);
					$familyData = $this->model->getRowData('family_customer',['customer_name'=>$customer_name]);
					if($primaryData){
						$data['address'] = $primaryData['address'];
						$data['address2'] = $primaryData['address2'];
						$data['address3'] = $primaryData['address3'];
						$data['city'] = $primaryData['city'];
						$data['state'] = $primaryData['state'];
						$data['pincode'] = $primaryData['pincode'];
						$data['divopt'] = $primaryData['divopt'];
						$data['customer_mobileno'] = $primaryData['customer_mobileno'];
						$data['occupation'] = $primaryData['occupation'];
						$data['customer_emailid'] = $primaryData['customer_emailid'];
						$data['birthdate'] = $primaryData['birthdate'];
					}else if($familyData){
						$primaryCusData = $this->model->getRowData('primary_customer',['customer_name'=>$familyData['primary_customer']]);
						$data['address'] = $primaryCusData['address'];
						$data['address2'] = $primaryCusData['address2'];
						$data['address3'] = $primaryCusData['address3'];
						$data['city'] = $primaryCusData['city'];
						$data['state'] = $primaryCusData['state'];
						$data['pincode'] = $primaryCusData['pincode'];
						$data['divopt'] = $primaryCusData['divopt'];
						$data['customer_mobileno'] = $familyData['customer_mobileno'];
						$data['occupation'] = $familyData['occupation'];
						$data['customer_emailid'] = $familyData['customer_emailid'];
						$data['birthdate'] = $familyData['birthdate'];
					}
					if(isset($policy_date_to))
					{
						$this->db->insert('primary_customer', $data);
					}
				}
			// }
		}
    }
	//Import RenewBuy
	public function importRenewbuy()
    {
        if(isset($_FILES["file"]["name"]))
		{
			$path = $_FILES["file"]["tmp_name"];
			$object = PHPExcel_IOFactory::load($path);
            //Import primary customer
			$pcusArr = array();
			
			// foreach($object->getWorksheetIterator() as $worksheet)
			// {
				$worksheet = $object->getActiveSheet();
				$highestRow = $worksheet->getHighestRow();
				$highestColumn = $worksheet->getHighestRow();
				for($row=2; $row<=$highestRow; $row++)
				{
					$policy_date_to = date('d-m-Y',PHPExcel_Shared_Date::ExcelToPHP($worksheet->getCellByColumnAndRow(1, $row)->getValue()));
					$policy_date_till = date('d-m-Y',PHPExcel_Shared_Date::ExcelToPHP($worksheet->getCellByColumnAndRow(2, $row)->getValue()));
					$customer_name = $worksheet->getCellByColumnAndRow(3, $row)->getValue();
					$model = $worksheet->getCellByColumnAndRow(4, $row)->getValue();
					$policy_number = $worksheet->getCellByColumnAndRow(5, $row)->getValue();
					$company_name = $worksheet->getCellByColumnAndRow(6, $row)->getValue();
					$provider = $worksheet->getCellByColumnAndRow(7, $row)->getValue();
					$policy_type = $worksheet->getCellByColumnAndRow(8, $row)->getValue();
					$sum_assured = $worksheet->getCellByColumnAndRow(9, $row)->getValue();
					$amount = $worksheet->getCellByColumnAndRow(10, $row)->getValue();
					$data = array(
						'policy_date_to'  => $policy_date_to,
						'policy_date_till'  => $policy_date_till,
						'customer_name'  => $customer_name,
						'model'  => $model,
						'policy_number'  => $policy_number,
						'company_name'  => $company_name,
						'provider'  => $provider,
						'policy_type'  => $policy_type,
						'sum_assured'  => $sum_assured,
						'amount'  => $amount,
						'type'  => 'Renew Buy',
					);
					if(isset($policy_date_to))
					{
						$this->db->insert('primary_customer', $data);
					}
				}
			// }
		}
    }
	public function importLi()
    {
        if(isset($_FILES["file"]["name"]))
		{
			$path = $_FILES["file"]["tmp_name"];
			$object = PHPExcel_IOFactory::load($path);
			// foreach($object->getWorksheetIterator() as $worksheet)
			// {
				$worksheet = $object->getActiveSheet();
				$highestRow = $worksheet->getHighestRow();
				$highestColumn = $worksheet->getHighestRow();
				for($row=2; $row<=$highestRow; $row++)
				{
					$customer_name = $worksheet->getCellByColumnAndRow(0, $row)->getValue();
					$company_name = $worksheet->getCellByColumnAndRow(1, $row)->getValue();
					$product_name = $worksheet->getCellByColumnAndRow(2, $row)->getValue();
					$policy_number = $worksheet->getCellByColumnAndRow(3, $row)->getValue();
					$policy_date_to = $worksheet->getCellByColumnAndRow(4, $row)->getValue();
					$policy_date_till = $worksheet->getCellByColumnAndRow(5, $row)->getValue();
					$sum_assured = $worksheet->getCellByColumnAndRow(6, $row)->getValue();
					$insurance_premium = $worksheet->getCellByColumnAndRow(7, $row)->getValue();

					$data = array(
						'customer_name'  => $customer_name,
						'company_name'  => $company_name,
						'product_name'  => $product_name,
						'policy_number'  => $policy_number,
						'policy_date_to'  => $policy_date_to,
						'policy_date_till'  => $policy_date_till,
						'sum_assured'  => $sum_assured,
						'amount'  => $insurance_premium,
						'type'  => 'LI',
					);
					if(isset($customer_name))
					{
						$this->db->insert('primary_customer', $data);
					}
				}
			// }
		}
    }
	public function importHDFCFD()
    {
		ini_set('max_execution_time', 0);
		ini_set('memory_limit','-1');
        if(isset($_FILES["file"]["name"]))
		{
			$path = $_FILES["file"]["tmp_name"];
			$object = PHPExcel_IOFactory::load($path);
            //Import primary customer
			$pcusArr = array();
			
			// foreach($object->getWorksheetIterator() as $worksheet)
			// {
				$worksheet = $object->getActiveSheet();
				$highestRow = $worksheet->getHighestRow();
				$highestColumn = $worksheet->getHighestColumn();
				for($row=2; $row<=$highestRow; $row++)
				{
					$primaryCustomers = $this->model->getResultData('primary_customer',['is_suspended'=>0]);
					foreach($primaryCustomers as $pcus)
					{
						array_push($pcusArr,strtolower($pcus['customer_name']));

					}
					$customer_name = $worksheet->getCellByColumnAndRow(0, $row)->getValue();
					$fd_number = $worksheet->getCellByColumnAndRow(1, $row)->getValue();
					$customer_pan = $worksheet->getCellByColumnAndRow(2, $row)->getValue();
					$dep_amount = $worksheet->getCellByColumnAndRow(3, $row)->getValue();
					$tenure = $worksheet->getCellByColumnAndRow(4, $row)->getValue();
					$policy_date_to = $worksheet->getCellByColumnAndRow(5, $row)->getValue();
					$policy_date_till = $worksheet->getCellByColumnAndRow(6, $row)->getValue();
					$product_name = $worksheet->getCellByColumnAndRow(7, $row)->getValue();
					$client_id = $worksheet->getCellByColumnAndRow(8, $row)->getValue();
					
					if (!in_array(strtolower($customer_name), $pcusArr))
					{
						$data = array(
							'customer_name'  => $customer_name,
							'fd_number'  => $fd_number,
							'customer_pan'  => $customer_pan,
							'dep_amount'  => $dep_amount,
							'tenure'  => $tenure,
							'policy_date_to'  => $policy_date_to,
							'policy_date_till'  => $policy_date_till,
							'product_name'  => $product_name,
							'client_id'  => $client_id,
							'type'  => 'HDFC FD',
						); 
						// echo "<pre>";print_r($data);
						$this->db->insert('primary_customer', $data);
					}
				}
		}
    }
	// public function importHDFCFD()
    // {
    //     if(isset($_FILES["file"]["name"]))
	// 	{
	// 		$path = $_FILES["file"]["tmp_name"];
	// 		$object = PHPExcel_IOFactory::load($path);
	// 		// foreach($object->getWorksheetIterator() as $worksheet)
	// 		// {
	// 			$worksheet = $object->getActiveSheet();
	// 			$highestRow = $worksheet->getHighestRow();
	// 			$highestColumn = $worksheet->getHighestRow();
	// 			for($row=2; $row<=$highestRow; $row++)
	// 			{
	// 				$customer_name = $worksheet->getCellByColumnAndRow(0, $row)->getValue();
	// 				$fd_number = $worksheet->getCellByColumnAndRow(1, $row)->getValue();
	// 				$customer_pan = $worksheet->getCellByColumnAndRow(2, $row)->getValue();
	// 				$dep_amount = $worksheet->getCellByColumnAndRow(3, $row)->getValue();
	// 				$tenure = $worksheet->getCellByColumnAndRow(4, $row)->getValue();
	// 				$policy_date_to = $worksheet->getCellByColumnAndRow(5, $row)->getValue();
	// 				$policy_date_till = $worksheet->getCellByColumnAndRow(6, $row)->getValue();
	// 				$product_name = $worksheet->getCellByColumnAndRow(7, $row)->getValue();
	// 				$client_id = $worksheet->getCellByColumnAndRow(8, $row)->getValue();

	// 				$data = array(
	// 					'customer_name'  => $customer_name,
	// 					'fd_number'  => $fd_number,
	// 					'customer_pan'  => $customer_pan,
	// 					'dep_amount'  => $dep_amount,
	// 					'tenure'  => $tenure,
	// 					'policy_date_to'  => $policy_date_to,
	// 					'policy_date_till'  => $policy_date_till,
	// 					'product_name'  => $product_name,
	// 					'client_id'  => $client_id,
	// 					'type'  => 'HDFC FD',
	// 				);
	// 				if(isset($customer_name))
	// 				{
	// 					$this->db->insert('primary_customer', $data);
	// 				}
	// 			}
	// 		// }
	// 	}
    // }
	public function importICICIPLI()
    {
        if(isset($_FILES["file"]["name"]))
		{
			$path = $_FILES["file"]["tmp_name"];
			$object = PHPExcel_IOFactory::load($path);
			// foreach($object->getWorksheetIterator() as $worksheet)
			// {
				$worksheet = $object->getActiveSheet();
				$highestRow = $worksheet->getHighestRow();
				$highestColumn = $worksheet->getHighestRow();
				for($row=2; $row<=$highestRow; $row++)
				{
					$policy_number = $worksheet->getCellByColumnAndRow(0, $row)->getValue();
					$policy_name = $worksheet->getCellByColumnAndRow(1, $row)->getValue();
					$policy_date_to = $worksheet->getCellByColumnAndRow(2, $row)->getValue();
					// $risk_commencement = $worksheet->getCellByColumnAndRow(3, $row)->getValue();
					$risk_date = date('d-m-Y',PHPExcel_Shared_Date::ExcelToPHP($worksheet->getCellByColumnAndRow(3, $row)->getValue()));
					$sum_assured = $worksheet->getCellByColumnAndRow(4, $row)->getValue();
					$premium_installment = $worksheet->getCellByColumnAndRow(5, $row)->getValue();
					// $payment_frequency = $worksheet->getCellByColumnAndRow(6, $row)->getValue();
					$policy_term = $worksheet->getCellByColumnAndRow(7, $row)->getValue();
					$premium_paying = $worksheet->getCellByColumnAndRow(8, $row)->getValue();
					$annual_premium = $worksheet->getCellByColumnAndRow(9, $row)->getValue();
					$owner_name = $worksheet->getCellByColumnAndRow(10, $row)->getValue();
					$address = $worksheet->getCellByColumnAndRow(11, $row)->getValue();
					$city = $worksheet->getCellByColumnAndRow(12, $row)->getValue();
					$customer_mobileno = $worksheet->getCellByColumnAndRow(13, $row)->getValue();
					$customer_emailid = $worksheet->getCellByColumnAndRow(14, $row)->getValue();
					$birthdate = $worksheet->getCellByColumnAndRow(15, $row)->getValue();
					$premium_due = $worksheet->getCellByColumnAndRow(16, $row)->getValue();
					$policy_date_till = $worksheet->getCellByColumnAndRow(17, $row)->getValue();
					$address_status = $worksheet->getCellByColumnAndRow(18, $row)->getValue();
					$payment_mode = $worksheet->getCellByColumnAndRow(19, $row)->getValue();

					$data = array(
						
						'policy_number'  => $policy_number,
						'policy_name'  => $policy_name,
						'policy_date_to'  => $policy_date_to,
						'risk_date'  => $risk_date,
						'sum_assured'  => $sum_assured,
						'premium_installment'  => $premium_installment,
						// 'payment_frequency'  => $payment_frequency,
						'policy_term'  => $policy_term,
						'premium_paying'  => $premium_paying,
						'annual_premium'  => $annual_premium,
						'customer_name'  => $owner_name,
						'address'  => $address,
						'city'  => $city,
						'customer_mobileno'  => $customer_mobileno,
						'customer_emailid'  => $customer_emailid,
						'birthdate'  => $birthdate,
						'premium_due'  => $premium_due,
						'policy_date_till'  => $policy_date_till,
						'address_status'  => $address_status,
						'payment_mode'  => $payment_mode,
						'type'  => 'ICICI PLI',
					);
					if(isset($owner_name))
					{
						$this->db->insert('primary_customer', $data);
					}
				}
			// }
		}
    }
	public function importPNBFD()
    {
        if(isset($_FILES["file"]["name"]))
		{
			$path = $_FILES["file"]["tmp_name"];
			$object = PHPExcel_IOFactory::load($path);
			// foreach($object->getWorksheetIterator() as $worksheet)
			// {
				$worksheet = $object->getActiveSheet();
				$highestRow = $worksheet->getHighestRow();
				$highestColumn = $worksheet->getHighestRow();
				for($row=2; $row<=$highestRow; $row++)
				{
					$customer_name = $worksheet->getCellByColumnAndRow(0, $row)->getValue();
					$FDR_number = $worksheet->getCellByColumnAndRow(1, $row)->getValue();
					$customer_pan = $worksheet->getCellByColumnAndRow(2, $row)->getValue();
					$dep_amount = $worksheet->getCellByColumnAndRow(3, $row)->getValue();
					$tenure = $worksheet->getCellByColumnAndRow(4, $row)->getValue();
					$policy_date_to = date('d-m-Y',PHPExcel_Shared_Date::ExcelToPHP($worksheet->getCellByColumnAndRow(5, $row)->getValue()));
					$policy_date_till = date('d-m-Y',PHPExcel_Shared_Date::ExcelToPHP($worksheet->getCellByColumnAndRow(6, $row)->getValue()));
					$product_name = $worksheet->getCellByColumnAndRow(7, $row)->getValue();
					$client_id = $worksheet->getCellByColumnAndRow(8, $row)->getValue();

					$data = array(
						'customer_name'  => $customer_name,
						'FDR_number'  => $FDR_number,
						'customer_pan'  => $customer_pan,
						'dep_amount'  => $dep_amount,
						'tenure'  => $tenure,
						'policy_date_to'  => $policy_date_to,
						'policy_date_till'  => $policy_date_till,
						'product_name'  => $product_name,
						'client_id'  => $client_id,
						'type'  => 'PNB FD',
					);
					if(isset($customer_name) && $customer_name!=='')
					{
						$this->db->insert('primary_customer', $data);
					}
				}
			// }
		}
    }
	public function importTanService()
    {
        if(isset($_FILES["file"]["name"]))
		{
			$path = $_FILES["file"]["tmp_name"];
			$object = PHPExcel_IOFactory::load($path);
			// foreach($object->getWorksheetIterator() as $worksheet)
			// {
				$worksheet = $object->getActiveSheet();
				$highestRow = $worksheet->getHighestRow();
				$highestColumn = $worksheet->getHighestRow();
				for($row=2; $row<=$highestRow; $row++)
				{
					$name = $worksheet->getCellByColumnAndRow(1, $row)->getValue();
					$customer_name = explode("$",$name)[0];
					$address = $worksheet->getCellByColumnAndRow(1, $row)->getValue();
					$customer_address = explode("$",$name)[1];
					$sa_in_lakh = $worksheet->getCellByColumnAndRow(2, $row)->getValue();
					$plan_term = $worksheet->getCellByColumnAndRow(3, $row)->getValue();
					$mode = $worksheet->getCellByColumnAndRow(4, $row)->getValue();
					// $risk_date = $worksheet->getCellByColumnAndRow(5, $row)->getValue();
					$risk_date = date('d-m-Y',PHPExcel_Shared_Date::ExcelToPHP($worksheet->getCellByColumnAndRow(5, $row)->getValue()));
					$policy_number = $worksheet->getCellByColumnAndRow(6, $row)->getValue();
					$premium_amount = $worksheet->getCellByColumnAndRow(7, $row)->getValue();
					$birthdate = date('d-m-Y',PHPExcel_Shared_Date::ExcelToPHP($worksheet->getCellByColumnAndRow(8, $row)->getValue()));
					$branch_code = $worksheet->getCellByColumnAndRow(9, $row)->getValue();

					$data = array(
						'customer_name'  => $customer_name,
						'address'  => $customer_address,
						'policy_number'  => $policy_number,
						'sa_in_lakh'  => $sa_in_lakh,
						'plan_term'  => $plan_term,
						'payment_mode'  => $mode,
						'risk_date'  => $risk_date,
						'premium_amount'  => $premium_amount,
						'birthdate'  => $birthdate,
						'branch_code'  => $branch_code,
						'type'  => 'tan-service',
					);
					if(isset($customer_name))
					{
						$this->db->insert('primary_customer', $data);
					}
					
				}
			// }
		}
    }
	public function importRtrr()
    {
		ini_set('max_execution_time', 0);
		ini_set('memory_limit','-1');
        if(isset($_FILES["file"]["name"]))
		{
			$path = $_FILES["file"]["tmp_name"];
			$object = PHPExcel_IOFactory::load($path);
			// foreach($object->getWorksheetIterator() as $worksheet)
			// {
				$worksheet = $object->getActiveSheet();
				$highestRow = $worksheet->getHighestRow();
				$highestColumn = $worksheet->getHighestRow();
				for($row=2; $row<=$highestRow; $row++)
				{
					$name = $worksheet->getCellByColumnAndRow(1, $row)->getValue();
					$customer_name = explode("$",$name)[0];
					$address = $worksheet->getCellByColumnAndRow(1, $row)->getValue();
					if(isset(explode("$",$name)[1])){
						$customer_address = explode("$",$name)[1];
					}else{
						$customer_address = '';
					}
					
					$sa_in_lakh = $worksheet->getCellByColumnAndRow(2, $row)->getValue();
					$plan_term = $worksheet->getCellByColumnAndRow(3, $row)->getValue();
					$mode = $worksheet->getCellByColumnAndRow(4, $row)->getValue();
					// $risk_date = $worksheet->getCellByColumnAndRow(5, $row)->getValue();
					$risk_date = date('d-m-Y',PHPExcel_Shared_Date::ExcelToPHP($worksheet->getCellByColumnAndRow(5, $row)->getValue()));
					$policy_number = $worksheet->getCellByColumnAndRow(6, $row)->getValue();
					$premium_amount = $worksheet->getCellByColumnAndRow(7, $row)->getValue();
					
					// $birthdate = $worksheet->getCellByColumnAndRow(8, $row)->getValue();
					$branch_code = $worksheet->getCellByColumnAndRow(9, $row)->getValue();
					if($worksheet->getCellByColumnAndRow(8, $row)->getValue()){
						$birthdate = date('d-m-Y',PHPExcel_Shared_Date::ExcelToPHP($worksheet->getCellByColumnAndRow(8, $row)->getValue()));
					}else{
						$birthdate = '';
					}
					$data = array(
						'customer_name'  => $customer_name,
						'address'  => $customer_address,
						'policy_number'  => $policy_number,
						'sa_in_lakh'  => $sa_in_lakh,
						'plan_term'  => $plan_term,
						'payment_mode'  => $mode,
						'risk_date'  => $risk_date,
						'premium_amount'  => $premium_amount,
						'birthdate'  => $birthdate,
						'branch_code'  => $branch_code,
						'type'  => 'rttr',
					);
					if(isset($customer_name) && $customer_name!=='')
					{
						$this->db->insert('primary_customer', $data);
					}
					
				}
			// }
		}
    }
}
