<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Payment extends CI_Controller {

	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	
	public function index()
    {
        $data['title'] = 'Payment';
		$data['staffs'] = $this->model->getResultData('staff',['is_suspended'=>0]);
		$data['orders'] = $this->model->getResultData('order',['is_disable'=>0]);
        $page = 'payment/index';
        $this->header_and_footer($page, $data);
    }
	public function addPayment()
    {
        if($_POST['order_id'])
		{
			$array = array(
				'order_id' => $_POST['order_id'],
				'amount' => $_POST['amount'],
				'payment_mode' => $_POST['payment_mode'],
				'staff_id' => $_POST['staff_id'],
			);
			if($this->model->add('payment',$array))
			{
				echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
			}
		}
    }
	public function viewPayment()
    {
		$data['list'] = $this->payment_model->getPaymentResultData();
		$this->load->view('payment/tb',$data);
    }
	public function editPayment()
    {
		$data = $this->model->getRowData('payment',['id'=>$_POST['id']]);
		$response = array(
			'eid' => $_POST['id'],
			'order_id' => $data['order_id'],
			'amount' => $data['amount'],
			'payment_mode' => $data['payment_mode'],
			'staff_id' => $data['staff_id'],
		);
		echo json_encode($response);
    }
	public function updatePayment()
    {
        if(isset($_POST['id']))
		{
			$array = array(
				'order_id' => $_POST['order_id'],
				'amount' => $_POST['amount'],
				'payment_mode' => $_POST['payment_mode'],
				'staff_id' => $_POST['staff_id'],
			);
			if($this->model->edit('payment',$array,['id'=>$_POST['id']]))
			{
				echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
			}
		}
    }
	
}
