<div class="page-body">
          <div class="container-fluid">
            <div class="page-title">
              <div class="row">
                <div class="col-6">
                  <h3><?= $title; ?></h3>
                </div>
              </div>
            </div>
          </div>
          <!-- Container-fluid starts-->
          <div class="container-fluid">
            <div class="row">
              <div class="col-sm-12">
                <div class="card">
                  <div class="card-header">
                  <div class="row">
                  <div class="col-sm-6">
                    <h5><?= $title; ?></h5>
                  </div>
                  <div class="col-sm-6 text-right">
                    <button class="btn btn-success rounded " type="button" data-bs-toggle="modal" data-bs-target="#importModal" data-bs-original-title="Import Excel"><i class="fa fa-arrow-up"></i> Import Excel</button>
                    <button class="btn btn-success rounded add-btn" type="button" onclick="addFamilyCustomer()"><i class="fa fa-plus"></i> Add <?= $title; ?></button>
                   </div>
                 </div>
                  </div>
                  <div class="card-body">
                    <div class="table-responsive" id="tb">
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <!-- Container-fluid Ends-->
        </div>
        <!-- Modal -->
        <div class="modal fade modal-bookmark" id="addFamilyCustomerModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add <?= $title ?></h5>
                <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
                <form class="form-bookmark" id="add-family-customer-form">
                  <div class="row g-2">
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Primary Customer</label>
                      <select class="form-control" name="primary_customer_id" id="primary_customer_id">
                          <option value="">Select</option>
                          <?php foreach($primary_customers as $customer){ ?>
                            <option value="<?= $customer['customer_name']; ?>"><?= $customer['customer_name']; ?></option>
                          <?php } ?>
                      </select>                   
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Name</label>
                      <input class="form-control" id="customer_name" type="text" name="customer_name">
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Email</label>
                      <input class="form-control" id="customer_emailid" type="email" name="customer_emailid">
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Mobile</label>
                      <input name="customer_mobileno"  id="customer_mobileno" class="form-control" type="text" pattern="[1-9]{1}[0-9]{9}" title="Enter 10 digit contact number" placeholder="Mobile number" maxlength="10" >
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Date of Birth</label>
                      <input class="form-control" id="birthdate" type="date" name="birthdate" max="<?= date("Y-m-d"); ?>">
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Anniversary date</label>
                      <input class="form-control" id="anniversary_date" type="date" name="anniversary_date" max="<?= date("Y-m-d"); ?>">
                    </div>
                    <div class="mb-3 mt-0 col-md-4">
                      <label for="bm-title">Country</label>
                      <select name="country" class="form-control" id="country" onchange="fetch_state(this.value)">
                          <option value="">Select Country</option>
                          <?php foreach($countries as $country){ ?>
                            <option value="<?= $country['id']; ?>"><?= $country['name']; ?></option>
                          <?php } ?>
                      </select>                   
                    </div>
                    <div class="mb-3 mt-0 col-md-4">
                      <label for="bm-title">State</label>
                      <select name="state" class="state form-control" id="state" onchange="fetch_city(this.value)">
                      </select>                    
                    </div>
                    <div class="mb-3 mt-0 col-md-4">
                      <label for="bm-title">City</label>
                      <select name="city" class="city form-control" id="city">
                      </select>                 
                    </div>
                    <div class="mb-3 mt-0 col-md-12">
                      <label for="bm-title">Address</label>
                      <textarea class="form-control" id="address" name="address"></textarea>
                    </div>
                    <div class="mb-3 mt-0 col-md-12">
                      <label for="bm-title">Pincode</label>
                      <input class="form-control" id="pincode" type="number" name="pincode" >
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="exampleFormControlInput1">Pancard:</label>
                            <input class="form-control" type="file" name="pancard">

                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="exampleFormControlInput1">Aadhar Card:</label>
                            <input class="form-control" type="file" name="aadhar">

                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="exampleFormControlInput1">Other1:</label>
                            <input class="form-control" type="file" name="other1">

                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="exampleFormControlInput1">Other2:</label>
                            <input class="form-control" type="file" name="other2">

                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="exampleFormControlInput1">Important Document 1:</label>
                            <input class="form-control" type="file" name="imp_doc1">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="exampleFormControlInput1">Important Document 2:</label>
                            <input class="form-control" type="file" name="imp_doc2">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="exampleFormControlInput1">Important Document 3:</label>
                            <input class="form-control" type="file" name="imp_doc3">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="exampleFormControlInput1">Important Document 4:</label>
                            <input class="form-control" type="file" name="imp_doc4">
                        </div>
                    </div>
                    
                    
                  </div>
                  <button class="btn btn-secondary" type="submit">Add</button>
                  <button class="btn btn-primary" type="button" data-bs-dismiss="modal">Cancel</button>
                </form>
              </div>
            </div>
          </div>
        </div>

        <!-- Modal -->
        <div class="modal fade modal-bookmark" id="editFamilyCustomerModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
          <div class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title" id="exampleModalLabel">Edit <?= $title; ?></h5>
              <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
              <form class="form-bookmark" id="edit-family-customer-form">
                <div class="row g-2">
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Primary Customer</label>
                      <select class="form-control" name="primary_customer_id" id="e_primary_customer_id">
                          <option value="">Select</option>
                          <?php foreach($primary_customers as $customer){ ?>
                            <option value="<?= $customer['customer_name']; ?>"><?= $customer['customer_name']; ?></option>
                          <?php } ?>
                      </select>                   
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Name</label>
                      <input class="form-control" id="e_customer_name" type="text" name="customer_name">
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Email</label>
                      <input class="form-control" id="e_customer_emailid" type="email" name="customer_emailid">
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Mobile</label>
                      <input name="customer_mobileno"  id="e_customer_mobileno" class="form-control" type="text" pattern="[1-9]{1}[0-9]{9}" title="Enter 10 digit contact number" placeholder="Mobile number" maxlength="10" >
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Date of Birth</label>
                      <input class="form-control" id="e_birthdate" type="date" name="birthdate" max="<?= date("Y-m-d"); ?>">
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Anniversary date</label>
                      <input class="form-control" id="e_anniversary_date" type="date" name="anniversary_date" max="<?= date("Y-m-d"); ?>">
                    </div>
                    <div class="mb-3 mt-0 col-md-4">
                      <label for="bm-title">Country</label>
                      <select name="country" class="form-control" id="e_country" onchange="fetch_state(this.value)">
                          <option value="">Select Country</option>
                          <?php foreach($countries as $country){ ?>
                            <option value="<?= $country['id']; ?>"><?= $country['name']; ?></option>
                          <?php } ?>
                      </select>                   
                    </div>
                    <div class="mb-3 mt-0 col-md-4">
                      <label for="bm-title">State</label>
                      <select name="state" class="state form-control" id="e_state" onchange="fetch_city(this.value)">
                      </select>                    
                    </div>
                    <div class="mb-3 mt-0 col-md-4">
                      <label for="bm-title">City</label>
                      <select name="city" class="city form-control" id="e_city">
                      </select>                 
                    </div>
                    <div class="mb-3 mt-0 col-md-12">
                      <label for="bm-title">Address</label>
                      <textarea class="form-control" id="e_address" name="address"></textarea>
                    </div>
                    <div class="mb-3 mt-0 col-md-12">
                      <label for="bm-title">Pincode</label>
                      <input class="form-control" id="e_pincode" type="number" name="pincode">
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="exampleFormControlInput1">Pancard:</label>
                            <input class="form-control" type="file" name="pancard" id="pancard">
                            <img id="pancard_image" height="70" style="display:none;margin-top:20px">

                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="exampleFormControlInput1">Aadhar Card:</label>
                            <input class="form-control" type="file" name="aadhar" id="aadhar">
                            <img id="aadhar_image" height="70" style="display:none;margin-top:20px">

                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="exampleFormControlInput1">Other1:</label>
                            <input class="form-control" type="file" name="other1" id="other1">
                            <img id="other1_image" height="70" style="display:none;margin-top:20px">

                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="exampleFormControlInput1">Other2:</label>
                            <input class="form-control" type="file" name="other2" id="other2">
                            <img id="other2_image" height="70" style="display:none;margin-top:20px">

                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="exampleFormControlInput1">Important Document 1:</label>
                            <input class="form-control" type="file" name="imp_doc1" id="imp_doc1">
                            <img id="imp_doc1_image" height="70" style="display:none;margin-top:20px">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="exampleFormControlInput1">Important Document 2:</label>
                            <input class="form-control" type="file" name="imp_doc2" id="imp_doc2">
                            <img id="imp_doc2_image" height="70" style="display:none;margin-top:20px">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="exampleFormControlInput1">Important Document 3:</label>
                            <input class="form-control" type="file" name="imp_doc3" id="imp_doc3">
                            <img id="imp_doc3_image" height="70" style="display:none;margin-top:20px">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="exampleFormControlInput1">Important Document 4:</label>
                            <input class="form-control" type="file" name="imp_doc4" id="imp_doc4">
                            <img id="imp_doc4_image" height="70" style="display:none;margin-top:20px">
                        </div>
                    </div>
                </div>
                <input type="hidden" id="e_id" name="id">
                <button class="btn btn-secondary" type="submit">Update</button>
                <button class="btn btn-primary" type="button" data-bs-dismiss="modal">Cancel</button>
            </form>
            </div>
          </div>
        </div>
        </div>
        <!-- Import Modal -->
        <div class="modal fade modal-bookmark" id="importModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Import Excel</h5>
                <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
                <form class="form-bookmark" id="import-form">
                  <div class="row g-2">
                    <div class="mb-3 mt-0 col-md-12">
                      <label for="bm-title">Select excel file</label>
                      <input class="form-control" name="file" id="file" type="file"required="" accept=".xls, .xlsx">
                    </div>
                  </div>
                  <button class="btn btn-secondary" type="submit">Import</button>
                </form>
              </div>
            </div>
          </div>
        </div>
<script>
  function addFamilyCustomer()
  {
    $('#addFamilyCustomerModal').modal('toggle'); 
    $('#add-family-customer-form')[0].reset();
    $('#city').find('option:not(:first)').remove();
    $('#state').find('option:not(:first)').remove();
  }
$(document).ready(function(){
  $("#tb").html('<div class="text-center"><img src="loader.gif"></div>');
  $('#tb').load('<?= base_url('customer/viewGroupedFamilyCustomer'); ?>');
});


$("#add-family-customer-form").submit(function(e){
  e.preventDefault();
  $.ajax({
      url: "<?php echo base_url('customer/addFamilyCustomer'); ?>",
      method: "POST",
      data:  new FormData(this),
      cache: false,
      contentType: false,
      processData: false,
      dataType: 'json',
      success:function(res){
        if(res.return)
        {
          $('#addFamilyCustomerModal').modal('toggle'); 
          $('#add-family-customer-form')[0].reset();
          $("#tb").html('<div class="text-center"><img src="loader.gif"></div>');
          $('#tb').load('<?= base_url('customer/viewGroupedFamilyCustomer'); ?>');
          toastr.success(res.msg);
        }
        else
        {
          toastr.error(res.msg);
        }
      }
  });
})
function editFamilyCustomer(id)
{
  $.ajax({
      url: "<?= base_url('customer/editFamilyCustomer'); ?>",
      method: "POST",
        dataType: 'json',
      data: {
          id:id
      },
      success:function(res){
          $("#e_primary_customer_id option[value='"+res.primary_customer_id+"']").attr("selected", "selected");
          fetch_state(res.country,res.state);
          fetch_city(res.state,res.city);
          $("#e_id").val(res.id);
          $("#e_customer_name").val(res.customer_name);
          $("#e_customer_emailid").val(res.customer_emailid);
          $("#e_customer_mobileno").val(res.customer_mobileno);
          $("#e_birthdate").val(res.birthdate);
          $("#e_anniversary_date").val(res.anniversary_date);
          $("#e_address").val(res.address);
          $("#e_country option[value='"+res.country+"']").attr("selected", "selected");
          $("#e_pincode").val(res.pincode);

          $("#pancard_image").css('display','block');
          $("#pancard_image").attr("src", ""+res.pancard+"");
          
          $("#aadhar_image").css('display','block');
          $("#aadhar_image").attr("src", ""+res.aadhar+"");
          
          $("#other1_image").css('display','block');
          $("#other1_image").attr("src", ""+res.other1+"");
          
          $("#other2_image").css('display','block');
          $("#other2_image").attr("src", ""+res.other2+"");

          $("#imp_doc1_image").css('display','block');
          $("#imp_doc1_image").attr("src", ""+res.imp_doc1+"");
          
          $("#imp_doc2_image").css('display','block');
          $("#imp_doc2_image").attr("src", ""+res.imp_doc2+"");
          
          $("#imp_doc3_image").css('display','block');
          $("#imp_doc3_image").attr("src", ""+res.imp_doc3+"");
          
          $("#imp_doc4_image").css('display','block');
          $("#imp_doc4_image").attr("src", ""+res.imp_doc4+"");
      }
  });
};
$("#edit-family-customer-form").submit(function(e){
  e.preventDefault();
  $.ajax({
      url: "<?php echo base_url('customer/updateFamilyCustomer'); ?>",
      method: "POST",
      data:  new FormData(this),
      cache: false,
      contentType: false,
      processData: false,
      dataType: 'json',
      success:function(res){
        if(res.return)
        {
          $('#editFamilyCustomerModal').modal('toggle'); 
          $("#tb").html('<div class="text-center"><img src="loader.gif"></div>');
          $('#tb').load('<?= base_url('customer/viewGroupedFamilyCustomer'); ?>');
          toastr.success(res.msg);
        }
        else
        {          
          toastr.error(res.msg);
        }
      }
  });
})

  function fetch_state(country_id,state_id) {
    $.ajax({
      url: "<?= base_url('dashboard/fetch_state'); ?>",
      method: "POST",
      data: {
        country_id: country_id,
        state_id: state_id
      },
      success: function(data) {
        if(state_id == null)
        {
          $(".state").html(data);
        }
        else
        {
          $("#e_state").html(data);
        }
      },
    });
  }
  function fetch_city(state_id,city_id) {
    $.ajax({
      url: "<?= base_url('dashboard/fetch_city'); ?>",
      method: "POST",
      data: {
        state_id: state_id,
        city_id: city_id
      },
      success: function(data) {
        if(city_id == null)
        {
          $(".city").html(data);
        }
        else
        {
          $("#e_city").html(data);
        }
      },
    });
  }
  $("#import-form").submit(function(e){
    e.preventDefault();
    $.ajax({
        url: "<?php echo base_url('customer/importFamilyCustomer'); ?>",
        method: "POST",
        data: new FormData(this),
        contentType:false,
        cache:false,
        processData:false,
        success:function(res){
          $('#importModal').modal('toggle'); 
          $('#file').val('');
          $('#tb').html(res);
          toastr.success("Imported Successfully");
        }
    });
  });
</script>