<script>
    $(document).ready(function() {
        $('#mytable').DataTable();
    } );
    if($('#usertype').val() == 'staff')
      {
          $('.edit-btn').remove();
          $('.add-btn').remove();
          $('.forgot-password').remove();
      }
</script>
<table class="table table-bordered" id="mytable">
  <thead>
    <tr>
      <th scope="col">Lead No.</th>
      <th scope="col">Fullname</th>
      <th scope="col">Email</th>
      <th scope="col">Mobile</th>
      <th scope="col">Date</th>
      <th scope="col">Action</th>
    </tr>
  </thead>
  <tbody>
    <?php 
    $i=1; 
    foreach($list as $val) { 
        ?>
    <tr>
      <th scope="row"><?= $val['id']; ?></th>
      <td><?= $val['fullname']; ?></td>
      <td><?= $val['emailid']; ?></td>
      <td><?= $val['mobile']; ?></td>
      <td><?= date('d-m-Y',strtotime($val['created']));?></td>
      <td>
        <a href="javascript:void(0)" class="btn btn-info btn-sm edit-btn" onclick="editStaff(<?= $val['id']; ?>)" data-bs-toggle="modal" data-bs-target="#editStaffModal">Edit</a>
        <?php if($this->session->userdata('usertype') == 'admin'){ ?>
       <?php if($val['is_suspended'] == '0'){ ?>
            <a href="javascript:void(0)" class="btn btn-danger btn-sm disable-btn" onclick="changeStatus(<?= $val['id']; ?>,'1')">Suspend</a>
        <?php } else{ ?>
            <a href="javascript:void(0)" class="btn btn-success btn-sm disable-btn" onclick="changeStatus(<?= $val['id']; ?>,'0')">Unsuspend</a>
        <?php } ?>
          <a href="javascript:void(0)" class="text-primary forgot-password" onclick="changePassword(<?= $val['id']; ?>)">Forgot Password</a>
        <?php } ?>
      </td>
    </tr>
    <?php } ?>
  </tbody>
</table>
<!-- Modal -->
<div class="modal fade modal-bookmark" id="changePasswordModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
          <div class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title" id="exampleModalLabel">Change Password</h5>
              <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
              <form class="form-bookmark" id="change-password-form">
                <div class="row g-2">
                  <div class="mb-3 mt-0 col-md-6">
                    <label for="bm-title">New Password</label>
                    <input class="form-control" id="new_password" type="password" required="">
                  </div>
                  <div class="mb-3 mt-0 col-md-6">
                    <label for="bm-title">Confirm Password</label>
                    <input class="form-control" id="confirm_password" type="password" required="">
                  </div>
                  <input type="hidden" id="staff_id">
                </div>
                <button class="btn btn-secondary submit-btn" type="submit">Save</button>
                <button class="btn btn-primary cancel-btn" type="button">Cancel</button>
              </form>
            </div>
          </div>
        </div>
      </div>
<script>
function changeStatus(id,type)
{
  if (confirm('Are you sure?') == true) {
    var table = 'staff';
    var column = 'is_suspended';
    $.ajax({
        url: "<?= base_url('Dashboard/Status'); ?>",
        method: "POST",
        data: {
            id:id,
            type:type,
            table:table,
            column:column,
            module:'staff detail'
        },
        dataType:'json',
        success:function(res){
          if(res.return)
          {
            $("#tb").load("<?= base_url('Staff/viewStaff/') ?>")
            toastr.success(res.msg);
          }
          else
          {          
            toastr.error(res.msg);
          }
        }
    });
  }
};
function changePassword(id)
{
  $('#changePasswordModal').modal('toggle'); 
  $('#staff_id').val(id); 
};
$("#change-password-form").submit(function(e){
  e.preventDefault();
  if($('#new_password').val() !== $('#confirm_password').val()){
    toastr.error("New Password and confirm password does not match");
    return false;
  }
  $.ajax({
      url: "<?php echo base_url('staff/changePassword'); ?>",
      method: "POST",
      data: {
          id:$('#staff_id').val(),
          password:$('#new_password').val()
      },
      success:function(res){
        $('#changePasswordModal').modal('toggle'); 
        $('#change-password-form')[0].reset();
        $('#tb').html(res);
        toastr.success("Password Changed Successfully");
      }
  });
});
</script>