<div class="page-body">
          <div class="container-fluid">
            <div class="page-title">
              <div class="row">
                <div class="col-6">
                  <h3><?= $title; ?></h3>
                </div>
              </div>
            </div>
          </div>
          <!-- Container-fluid starts-->
          <div class="container-fluid">
            <div class="row">
              <div class="col-sm-12">
                <div class="card">
                  <div class="card-header">
                  <div class="row">
                  <div class="col-sm-6">
                    <h5><?= $title; ?></h5>
                  </div>
                  <div class="col-sm-6 text-right">
                    <button class="btn btn-success rounded add-btn" type="button" data-bs-toggle="modal" data-bs-target="#addPaymentModal" data-bs-original-title="Add <?= $title; ?>"><i class="fa fa-plus"></i> Add <?= $title; ?></button>
                   </div>
                 </div>
                  </div>
                  <div class="card-body">
                    <div class="table-responsive" id="tb">
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <!-- Container-fluid Ends-->
        </div>
        <!-- Modal -->
        <div class="modal fade modal-bookmark" id="addPaymentModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add <?= $title; ?></h5>
                <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
                <form class="form-bookmark" id="add-payment-form">
                  <div class="row g-2">
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Order</label>
                      <select name="order_id" class="form-control" id="order_id" required>
                          <option value="">Select</option>
                          <?php foreach($orders as $order){ ?>
                            <option value="<?= $order['id']; ?>"><?= $order['order_id']; ?></option>
                          <?php } ?>
                      </select>                   
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Amount</label>
                      <input class="form-control" type="number" name="amount" id="amount" required>              
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Payment Mode</label>
                      <select name="payment_mode" class="form-control" id="payment_mode" required>
                        <option value="">Select</option>
                        <option value="Cash">Cash</option>
                        <option value="Card">Card</option>
                        <option value="UPI">UPI</option>
                        <option value="NEFT">NEFT</option>
                        <option value="Cheque">Cheque</option>
                      </select>              
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Received by</label>
                      <select name="staff_id" class="form-control" id="staff_id" <?php if($this->session->userdata('usertype') == 'staff'){ echo 'disabled';} ?> required>
                          <option value="">Select staff</option>
                          <?php foreach($staffs as $staff){ ?>
                            <option value="<?= $staff['id']; ?>" <?php if($this->session->userdata('usertype') == 'staff'){ echo ($this->session->userdata('id') == $staff['id']) ? "selected" : "";} ?>><?= $staff['fullname']; ?></option>
                          <?php } ?>
                      </select>                   
                    </div>
                  </div>
                  <button class="btn btn-secondary" type="submit">Add</button>
                  <button class="btn btn-primary" type="button" data-bs-dismiss="modal">Cancel</button>
                </form>
              </div>
            </div>
          </div>
        </div>

        <!-- Modal -->
        <div class="modal fade modal-bookmark" id="editPaymentModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Edit Payment</h5>
                <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
                <form class="form-bookmark" id="edit-payment-form">
                  <div class="row g-2">
                  <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Order</label>
                      <select name="order_id" class="form-control" id="e_order_id" required>
                          <option value="">Select</option>
                          <?php foreach($orders as $order){ ?>
                            <option value="<?= $order['id']; ?>" required><?= $order['order_id']; ?></option>
                          <?php } ?>
                      </select>                   
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Amount</label>
                      <input class="form-control" type="number" name="amount" id="e_amount" required>              
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Payment Mode</label>
                      <select name="payment_mode" class="form-control" id="e_payment_mode" required>
                        <option value="">Select</option>
                        <option value="Cash">Cash</option>
                        <option value="Card">Card</option>
                        <option value="UPI">UPI</option>
                        <option value="NEFT">NEFT</option>
                        <option value="Cheque">Cheque</option>
                      </select>              
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Received by</label>
                      <select name="staff_id" class="form-control" id="e_staff_id" required>
                          <option value="">Select staff</option>
                          <?php foreach($staffs as $staff){ ?>
                            <option value="<?= $staff['id']; ?>" <?php if($this->session->userdata('usertype') == 'staff'){ echo 'disabled';} ?>><?= $staff['fullname']; ?></option>
                          <?php } ?>
                      </select>                   
                    </div>
                  </div>
                  <input type="hidden" name="id" id="eid">
                  <button class="btn btn-secondary" type="submit">Update</button>
                  <button class="btn btn-primary" type="button" data-bs-dismiss="modal">Cancel</button>
                </form>
              </div>
            </div>
          </div>
        </div>

<script>
$(document).ready(function(){
  $.ajax({
      url: "<?= base_url('payment/viewPayment'); ?>",
      method: "POST",
      data: '',
      success:function(res){
          $('#tb').html(res);
      }
  });
});
$("#add-payment-form").submit(function(e){
  e.preventDefault();
  var formData = new FormData(this);
  $.ajax({
      url: "<?php echo base_url('payment/addPayment'); ?>",
      method: "POST",
      data:  formData,
      cache: false,
      contentType: false,
      processData: false,
      dataType:'json',
      success:function(res){
        if(res.return)
        {
          $('#addPaymentModal').modal('toggle'); 
          $('#add-payment-form')[0].reset();
          $('#tb').load('<?= base_url('payment/viewPayment'); ?>');
          toastr.success(res.msg);
        }
        else
        {
          toastr.error(res.msg);
        }
      }
  });
});
function editPayment(id)
{
  $.ajax({
      url: "<?php echo base_url('payment/editPayment'); ?>",
      method: "POST",
      data: {
          id:id
      },
      dataType: 'json',
      success:function(res){
        $("#eid").val(res.eid);
        $("#e_order_id option[value='"+res.order_id+"']").attr("selected", "selected");
        $("#e_staff_id option[value='"+res.staff_id+"']").attr("selected", "selected");
        $("#e_payment_mode option[value='"+res.payment_mode+"']").attr("selected", "selected");
        $("#e_amount").val(res.amount);
      }
  });
};
$("#edit-payment-form").submit(function(e){
  e.preventDefault();
  var formData = new FormData(this);
  $.ajax({
      url: "<?php echo base_url('payment/updatePayment'); ?>",
      method: "POST",
      data:  formData,
      cache: false,
      contentType: false,
      processData: false,
      dataType:'json',
      success:function(res){
        if(res.return)
        {
          $('#editPaymentModal').modal('toggle'); 
          $('#tb').load('<?= base_url('payment/viewPayment'); ?>');
          toastr.success(res.msg);
        }
        else
        {
          toastr.error(res.msg);
        }
      }
  });
});
</script>