<?php


class Model extends CI_Model
{
	public function add($table, $data)
	{
		return $this->db->insert($table, $data);
	}
	public function edit($tb,$data,$cond) 
	{
		return $this->db->where($cond)->update($tb,$data);
	}
	public function deleteData($tb,$cond)
	{
	 	return $this->db->where($cond)->delete($tb);
	}
	public function getRowData($table,$cond,$limit=null,$order_column=null,$order_type=null)
	{
		if($order_column!==null){
			$this->db->order_by($order_column,$order_type);
		}
		if($limit!==null){
			$this->db->limit($limit);
		}
		return $this->db->get_where($table, $cond)->row_array();
		  
	}
	public function getResultData($tb,$cond,$limit=null,$order_column=null,$order_type=null)
	{
		if($order_column!==null){
			$this->db->order_by($order_column,$order_type);
		}
		if($limit!==null){
			$this->db->limit($limit);
		}
		return $this->db->get_where($tb, $cond)->result_array();
	}
	public function countData($table,$cond)
	{
		return $this->db->get_where($table, $cond)->num_rows();
	}
	public function fetch_state($cid,$sid)
    {
        $data = $this->db->get_where('states', array('country_id' => $cid))->result_array();
        echo "<option value=''>Select State</option>";
        foreach ($data as $val) {
			if($val['id'] == $sid)
			{
				$sel = 'selected';
			}
			else
			{
				$sel = '';
			}
            echo "<option value='" . $val['id'] . "' ".$sel.">" . $val['name'] . "</option>";
        }
    }
	public function fetch_city($sid,$cid)
    {
        $data = $this->db->get_where('cities', array('state_id' => $sid))->result_array();
        echo "<option value=''>Select City</option>";
        foreach ($data as $val) {
			if($val['id'] == $cid)
			{
				$sel = 'selected';
			}
			else
			{
				$sel = '';
			}
            echo "<option value='" . $val['id'] . "' ".$sel.">" . $val['name'] . "</option>";
        }
    }
	public function fetch_family($cid,$fid)
    {
        $data = $this->db->get_where('family_customer', array('primary_customer_id' => $cid))->result_array();
        echo "<option value=''>Select Family</option>";
        foreach ($data as $val) {
			if($val['id'] == $fid)
			{
				$sel = 'selected';
			}
			else
			{
				$sel = '';
			}
            echo "<option value='" . $val['id'] . "' ".$sel.">" . $val['customer_name'] . "</option>";
        }
    }
	public function fetch_subcategory($cid,$sid)
    {
        $data = $this->db->get_where('product_subcategory', array('category_id' => $cid))->result_array();
        echo "<option value=''>Select</option>";
        foreach ($data as $val) {
			if($val['id'] == $sid)
			{
				$sel = 'selected';
			}
			else
			{
				$sel = '';
			}
            echo "<option value='" . $val['id'] . "' ".$sel.">" . $val['category_name'] . "</option>";
        }
    }
	
}

?>