<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Query extends CI_Controller {

	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	
	public function index()
    {
        $data['title'] = 'Query';
		$data['staffs'] = $this->model->getResultData('staff',['is_suspended'=>0]);
		$data['customers'] = $this->model->getResultData('primary_customer',['is_suspended'=>0]);
        $page = 'query/index';
        $this->header_and_footer($page, $data);
    }
	public function addQuery()
    {
        if($_POST['staff_id'])
		{
			$array = array(
				'staff_id' => $_POST['staff_id'],
				'customer_id' => $_POST['customer_id'],
				'family_id' => $_POST['family_id'],
				'query_description' => $_POST['query_description'],
				'status' => $_POST['status'],
			);
			if($this->model->add('query',$array))
			{
				echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
			}
		}
    }
	public function viewQuery()
    {
		$data['list'] = $this->query_model->getQueryResultData();
		$this->load->view('query/tb',$data);
    }
	public function editQuery()
    {
		$data = $this->model->getRowData('query',['id'=>$_POST['id']]);
		$response = array(
			'eid' => $_POST['id'],
			'staff_id' => $data['staff_id'],
			'customer_id' => $data['customer_id'],
			'family_id' => $data['family_id'],
			'query_description' => $data['query_description'],
			'status' => $data['status'],
		);
		echo json_encode($response);
    }
	public function updateQuery()
    {
        if(isset($_POST['id']))
		{
			$array = array(
				'staff_id' => $_POST['staff_id'],
				'customer_id' => $_POST['customer_id'],
				'family_id' => $_POST['family_id'],
				'query_description' => $_POST['query_description'],
				'status' => $_POST['status'],
			);
			if($this->model->edit('query',$array,['id'=>$_POST['id']]))
			{
				echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
			}
		}
    }
	
}
