<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Customer extends CI_Controller {

	public function __construct()
    {
        parent::__construct();

        // $this->isAdminLoggedIn();
    }


	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	public function primaryCustomer()
    {
        $data['title'] = 'Primary Customer';
		$data['countries'] = $this->model->getResultData('countries',[]);
        $page = 'primary_customer/index';
        $this->header_and_footer($page, $data);
    }
	public function addPrimaryCustomer()
    {
		$countEmail = $this->model->countData('primary_customer',['customer_emailid'=>$_POST['customer_emailid']]);
		if($countEmail > 0 )
		{
			echo json_encode(['return'=>false,'msg'=>'Email already exist']);
		}
		else
		{
			if($_POST['customer_name'])
			{
				$array = array(
					'customer_name' => ucfirst($_POST['customer_name']),
					'customer_emailid' => $_POST['customer_emailid'],
					'customer_mobileno' =>  $_POST['customer_mobileno'],
					'birthdate' =>  $_POST['birthdate'],
					'anniversary_date' =>  $_POST['anniversary_date'],
					'address' => $_POST['address'],
					'country' => $_POST['country'],
					'state' => $_POST['state'],
					'city' => $_POST['city'],
					'pincode' => $_POST['pincode'],
				);
				if($this->customer_model->addPrimaryCustomer($array))
				{
					echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
				}
				
			}
		}
    }
	public function viewPrimaryCustomer()
    {
		$type = null;
		$where = [];

		if(isset($_POST['type']) && $_POST['type'] !== ''){
			$where = ['type'=>$_POST['type']];
		}
		$data['list'] = $this->model->getResultData('primary_customer',$where);
		$this->load->view('primary_customer/tb',$data);
    }
	public function editPrimaryCustomer()
    {
        $response=array();
		$data = $this->model->getRowData('primary_customer',['id' => $_POST['id']]);
		$response = array(
			'id' => $_POST['id'],
			'customer_name' => $data['customer_name'],
			'customer_emailid' => $data['customer_emailid'],
			'customer_mobileno' =>  $data['customer_mobileno'],
			'birthdate' =>  $data['birthdate'],
			'anniversary_date' =>  $data['anniversary_date'],
			'address' => $data['address'],
			'country' => $data['country'],
			'state' => $data['state'],
			'city' => $data['city'],
			'pincode' => $data['pincode'],
			'pancard' => base_url('assets/uploads/'.$data['pancard'].''),
			'aadhar' => base_url('assets/uploads/'.$data['aadhar'].''),
			'other1' => base_url('assets/uploads/'.$data['other1'].''),
			'other2' => base_url('assets/uploads/'.$data['other2'].''),
			'imp_doc1' => base_url('assets/uploads/'.$data['imp_doc1'].''),
			'imp_doc2' => base_url('assets/uploads/'.$data['imp_doc2'].''),
			'imp_doc3' => base_url('assets/uploads/'.$data['imp_doc3'].''),
			'imp_doc4' => base_url('assets/uploads/'.$data['imp_doc4'].''),
		);
		echo json_encode($response);
    }
	public function updatePrimaryCustomer()
    {
		$countEmail = $this->model->countData('primary_customer',['customer_emailid'=>$_POST['customer_emailid'],'id!='=>$_POST['id']]);
		if($countEmail > 0 )
		{
			echo json_encode(['return'=>false,'msg'=>'Email already exist']);
		}
		else
		{
			if(isset($_POST['id']))
			{
				$array = array(
					'customer_name' => ucfirst($_POST['customer_name']),
					'customer_emailid' => $_POST['customer_emailid'],
					'customer_mobileno' =>  $_POST['customer_mobileno'],
					'birthdate' =>  $_POST['birthdate'],
					'anniversary_date' =>  $_POST['anniversary_date'],
					'address' => $_POST['address'],
					'country' => $_POST['country'],
					'state' => $_POST['state'],
					'city' => $_POST['city'],
					'pincode' => $_POST['pincode'],
				);
				if($this->customer_model->updatePrimaryCustomer($array,$_POST['id']))
				{
					echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
				}
			}
			else
			{
				echo json_encode(['return'=>false,'msg'=>'`id` is required']);
			}
		}
    }
  
    public function primaryCustomerDetail()
    {
        $id=$this->uri->segment(2);
        $data['title'] = 'Primary Customer Detail';
		$data['data'] = $this->customer_model->getPrimaryCustomerRowData($id);
        $page = 'primary_customer/detail';
        $this->header_and_footer($page, $data);
    }


	//Family customer
	public function familyCustomer()
    {
        $data['title'] = 'Family Customer';
		$data['primary_customers'] = $this->model->getResultData('primary_customer',['is_suspended'=>0]);
		$data['countries'] = $this->model->getResultData('countries',[]);
        $page = 'family_customer/index';
        $this->header_and_footer($page, $data);
    }
	public function addFamilyCustomer()
    {
		$countEmail = $this->model->countData('family_customer',['customer_emailid'=>$_POST['customer_emailid']]);
		if($countEmail > 0 )
		{
			echo json_encode(['return'=>false,'msg'=>'Email already exist']);
		}
		else
		{
			if($_POST['customer_name'])
			{
				$array = array(
					'primary_customer_id' => $_POST['primary_customer_id'],
					'customer_name' => ucfirst($_POST['customer_name']),
					'customer_emailid' => $_POST['customer_emailid'],
					'customer_mobileno' =>  $_POST['customer_mobileno'],
					'birthdate' =>  $_POST['birthdate'],
					'anniversary_date' =>  $_POST['anniversary_date'],
					'address' => $_POST['address'],
					'country' => $_POST['country'],
					'state' => $_POST['state'],
					'city' => $_POST['city'],
					'pincode' => $_POST['pincode'],
				);
				if($this->customer_model->addFamilyCustomer($array))
				{
					echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
				}
				
			}
		}
    }
	public function viewFamilyCustomer()
    {
		$data['list'] = $this->model->getResultData('family_customer',[]);
		$this->load->view('family_customer/tb',$data);
    }
	public function editFamilyCustomer()
    {
        $response=array();
		$data = $this->model->getRowData('family_customer',['id' => $_POST['id']]);
		$response = array(
			'id' => $_POST['id'],
			'primary_customer_id' => $data['primary_customer_id'],
			'customer_name' => $data['customer_name'],
			'customer_emailid' => $data['customer_emailid'],
			'customer_mobileno' =>  $data['customer_mobileno'],
			'birthdate' =>  $data['birthdate'],
			'anniversary_date' =>  $data['anniversary_date'],
			'address' => $data['address'],
			'country' => $data['country'],
			'state' => $data['state'],
			'city' => $data['city'],
			'pincode' => $data['pincode'],
			'pancard' => base_url('assets/uploads/'.$data['pancard'].''),
			'aadhar' => base_url('assets/uploads/'.$data['aadhar'].''),
			'other1' => base_url('assets/uploads/'.$data['other1'].''),
			'other2' => base_url('assets/uploads/'.$data['other2'].''),
			'imp_doc1' => base_url('assets/uploads/'.$data['imp_doc1'].''),
			'imp_doc2' => base_url('assets/uploads/'.$data['imp_doc2'].''),
			'imp_doc3' => base_url('assets/uploads/'.$data['imp_doc3'].''),
			'imp_doc4' => base_url('assets/uploads/'.$data['imp_doc4'].''),
		);
		echo json_encode($response);
    }
	public function updateFamilyCustomer()
    {
		$countEmail = $this->model->countData('family_customer',['customer_emailid'=>$_POST['customer_emailid'],'id!='=>$_POST['id']]);
		if($countEmail > 0 )
		{
			echo json_encode(['return'=>false,'msg'=>'Email already exist']);
		}
		else
		{
			if(isset($_POST['id']))
			{
				$array = array(
					'primary_customer_id' => $_POST['primary_customer_id'],
					'customer_name' => ucfirst($_POST['customer_name']),
					'customer_emailid' => $_POST['customer_emailid'],
					'customer_mobileno' =>  $_POST['customer_mobileno'],
					'birthdate' =>  $_POST['birthdate'],
					'anniversary_date' =>  $_POST['anniversary_date'],
					'address' => $_POST['address'],
					'country' => $_POST['country'],
					'state' => $_POST['state'],
					'city' => $_POST['city'],
					'pincode' => $_POST['pincode'],
				);
				if($this->customer_model->updateFamilyCustomer($array,$_POST['id']))
				{
					echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
				}
			}
			else
			{
				echo json_encode(['return'=>false,'msg'=>'`id` is required']);
			}
		}
    }
  
    public function familyCustomerDetail()
    {
        $id=$this->uri->segment(2);
        $data['title'] = 'Family Customer Detail';
		$data['data'] = $this->customer_model->getFamilyCustomerRowData($id);
        $page = 'family_customer/detail';
        $this->header_and_footer($page, $data);
    }	
	public function importPrimaryCustomer()
    {
        if(isset($_FILES["file"]["name"]))
		{
			$path = $_FILES["file"]["tmp_name"];
			$object = PHPExcel_IOFactory::load($path);
			$mobileArr = array();
			$allMobile = $this->model->getResultData('primary_customer',[]);
			foreach($allMobile as $all)
			{
				array_push($mobileArr,$all['customer_mobileno']);

			}
			// foreach($object->getWorksheetIterator() as $worksheet)
			// {
				$worksheet = $object->getActiveSheet();
				$highestRow = $worksheet->getHighestRow();
				$highestColumn = $worksheet->getHighestColumn();
				for($row=2; $row<=$highestRow; $row++)
				{
					$customer_name = $worksheet->getCellByColumnAndRow(1, $row)->getValue();
					$birthdate = $worksheet->getCellByColumnAndRow(2, $row)->getValue();
					$customer_mobileno = $worksheet->getCellByColumnAndRow(3, $row)->getValue();
					$customer_emailid = $worksheet->getCellByColumnAndRow(4, $row)->getValue();
					$address = $worksheet->getCellByColumnAndRow(5, $row)->getValue();
				// 	if (!in_array($customer_mobileno, $mobileArr))
				// 	{
						$data[] = array(
							'customer_name'  => $customer_name,
							'birthdate'  => $birthdate,
							'customer_mobileno'  => $customer_mobileno,
							'customer_emailid'  => $customer_emailid,
							'address'  => $address,
						);
				// 	}
				// 	else
				// 	{
				// 		$data[] = array();
				// 	}
				}
			// }
			if(!empty($data))
			{
			    $this->db->insert_batch('primary_customer', $data);
			}
			$this->viewPrimaryCustomer();
		}
    }
	public function importFamilyCustomer()
    {
        if(isset($_FILES["file"]["name"]))
		{
			$path = $_FILES["file"]["tmp_name"];
			$object = PHPExcel_IOFactory::load($path);
			$mobileArr = array();
			$pcusArr = array();
			$allMobile = $this->model->getResultData('family_customer',[]);
			$primaryCustomers = $this->model->getResultData('primary_customer',['is_suspended'=>0]);
			foreach($allMobile as $all)
			{
				array_push($mobileArr,$all['customer_mobileno']);

			}
			foreach($primaryCustomers as $pcus)
			{
				array_push($pcusArr,$pcus['id']);

			}
			foreach($object->getWorksheetIterator() as $worksheet)
			{
				$highestRow = $worksheet->getHighestRow();
				$highestColumn = $worksheet->getHighestColumn();
				for($row=2; $row<=$highestRow; $row++)
				{
					$customer_name = $worksheet->getCellByColumnAndRow(1, $row)->getValue();
					$birthdate = $worksheet->getCellByColumnAndRow(2, $row)->getValue();
					$customer_mobileno = $worksheet->getCellByColumnAndRow(3, $row)->getValue();
					$customer_emailid = $worksheet->getCellByColumnAndRow(4, $row)->getValue();
					$address = $worksheet->getCellByColumnAndRow(5, $row)->getValue();
					$primary_customer_id = $worksheet->getCellByColumnAndRow(6, $row)->getValue();
					if (in_array($primary_customer_id, $pcusArr))
					{
						$data[] = array(
							'primary_customer_id'  => $primary_customer_id,
							'customer_name'  => $customer_name,
							'birthdate'  => $birthdate,
							'customer_mobileno'  => $customer_mobileno,
							'customer_emailid'  => $customer_emailid,
							'address'  => $address,
						);
					}
				// 	else
				// 	{
				// 		$data[] = array();
				// 	}
				}
			}
			if(!empty($data))
			{
			    $this->db->insert_batch('family_customer', $data);
			}
			$this->viewFamilyCustomer();
		}
    }

	//Import customers
	public function customer()
    {
        $data['title'] = 'Customer';
		$data['customers'] = $this->model->getResultData('customers',[]);
        $page = 'customer/index';
        $this->header_and_footer($page, $data);
    }
	public function viewCustomer()
    {
		$data['list'] = $this->model->getResultData('customers',[]);
		$this->load->view('customer/tb',$data);
    }
  
	public function importCustomer()
    {
        if(isset($_FILES["file"]["name"]))
		{
			$path = $_FILES["file"]["tmp_name"];
			$object = PHPExcel_IOFactory::load($path);
			foreach($object->getWorksheetIterator() as $worksheet)
			{
				$highestRow = $worksheet->getHighestRow();
				$highestColumn = $worksheet->getHighestColumn();
				for($row=2; $row<=$highestRow; $row++)
				{
					$sno = $worksheet->getCellByColumnAndRow(1, $row)->getValue();
					echo $sno;
					// $customer_name = $worksheet->getCellByColumnAndRow(1, $row)->getValue();
					// $birthdate = $worksheet->getCellByColumnAndRow(2, $row)->getValue();
					// $customer_mobileno = $worksheet->getCellByColumnAndRow(3, $row)->getValue();
					// $customer_emailid = $worksheet->getCellByColumnAndRow(4, $row)->getValue();
					// $address = $worksheet->getCellByColumnAndRow(5, $row)->getValue();
					// $primary_customer_id = $worksheet->getCellByColumnAndRow(6, $row)->getValue();
					// $data[] = array(
					// 	'primary_customer_id'  => $primary_customer_id,
					// 	'customer_name'  => $customer_name,
					// 	'birthdate'  => $birthdate,
					// 	'customer_mobileno'  => $customer_mobileno,
					// 	'customer_emailid'  => $customer_emailid,
					// 	'address'  => $address,
					// );
				}
die('A');
			}
			if(!empty($data))
			{
			    $this->db->insert_batch('family_customer', $data);
			}
			$this->viewFamilyCustomer();
		}
    }

}
