<div class="page-body">
          <div class="container-fluid">
            <div class="page-title">
              <div class="row">
                <div class="col-6">
                  <h3><?= $title; ?></h3>
                </div>
              </div>
            </div>
          </div>
          <!-- Container-fluid starts-->
          <div class="container-fluid">
            <div class="row">
              <div class="col-sm-12">
                <div class="card">
                  <div class="card-header">
                  <div class="row">
                  <div class="col-sm-6">
                    <h5><?= $title; ?></h5>
                  </div>
                  <div class="col-sm-6 text-right">
                    <button class="btn btn-success rounded add-btn" type="button" data-bs-toggle="modal" data-bs-target="#addProductCategoryModal" data-bs-original-title="Add <?= $title; ?>"><i class="fa fa-plus"></i> Add <?= $title; ?></button>
                   </div>
                 </div>
                  </div>
                  <div class="card-body">
                    <div class="table-responsive" id="tb">
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <!-- Container-fluid Ends-->
        </div>
        <!-- Modal -->
        <div class="modal fade modal-bookmark" id="addProductCategoryModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add <?= $title; ?></h5>
                <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
                <form class="form-bookmark" id="add-product-category-form">
                  <div class="row g-2">
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Category Name</label>
                      <input class="form-control" name="category_name" id="category_name" type="text">
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Photo</label>
                      <input class="form-control" name="category_photo" id="category_photo" type="file">
                    </div>
                  </div>
                  <button class="btn btn-secondary" type="submit">Save</button>
                  <button class="btn btn-primary" type="button" data-bs-dismiss="modal">Cancel</button>
                </form>
              </div>
            </div>
          </div>
        </div>

        <!-- Modal -->
        <div class="modal fade modal-bookmark" id="editProductCategoryModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Edit Product Category</h5>
                <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
                <form class="form-bookmark" id="edit-product-category-form">
                  <div class="row g-2">
                  <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Category Name</label>
                      <input class="form-control" name="category_name" id="e_category_name" type="text">
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Photo</label>
                      <input class="form-control" name="category_photo" id="e_category_photo" type="file" >
                      <img id="category_photoview" height="70" style="display:none;margin-top:20px">
                    </div>
                  </div>
                  <input type="hidden" name="id" id="eid">
                  <button class="btn btn-secondary" type="submit">Update</button>
                  <button class="btn btn-primary" type="button" data-bs-dismiss="modal">Cancel</button>
                </form>
              </div>
            </div>
          </div>
        </div>

<script>
$(document).ready(function(){
  $.ajax({
      url: "<?= base_url('product/viewProductCategory'); ?>",
      method: "POST",
      data: '',
      success:function(res){
          $('#tb').html(res);
      }
  });
});
$("#add-product-category-form").submit(function(e){
  e.preventDefault();
  var formData = new FormData(this);
  $.ajax({
      url: "<?php echo base_url('product/addProductCategory'); ?>",
      method: "POST",
      data:  formData,
      cache: false,
      contentType: false,
      processData: false,
      dataType:'json',
      success:function(res){
        if(res.return)
        {
          $('#addProductCategoryModal').modal('toggle'); 
          $('#add-product-category-form')[0].reset();
          $('#tb').load('<?= base_url('product/viewProductCategory'); ?>');
          toastr.success(res.msg);
        }
        else
        {
          toastr.error(res.msg);
        }
      }
  });
});
function editProductCategory(id)
{
  $.ajax({
      url: "<?php echo base_url('product/editProductCategory'); ?>",
      method: "POST",
      data: {
          id:id
      },
      dataType: 'json',
      success:function(res){
        $("#eid").val(res.eid);
        $("#e_category_name").val(res.category_name);
         $("#category_photoview").css('display','block');
         $("#category_photoview").attr("src", ""+res.category_photo+"");
         $("#category_photoview").val(res.category_photo);
      }
  });
};
$("#edit-product-category-form").submit(function(e){
  e.preventDefault();
  var formData = new FormData(this);
  $.ajax({
      url: "<?php echo base_url('product/updateProductCategory'); ?>",
      method: "POST",
      data:  formData,
      cache: false,
      contentType: false,
      processData: false,
      dataType:'json',
      success:function(res){
        if(res.return)
        {
          $('#editProductCategoryModal').modal('toggle'); 
          $('#tb').load('<?= base_url('product/viewProductCategory'); ?>');
          toastr.success(res.msg);
        }
        else
        {
          toastr.error(res.msg);
        }
      }
  });
});

</script>