
<html>
  <head>
    <!-- Latest compiled and minified CSS -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">


  </head>
  <body>
      <div class="container">
        <div class="row" style="margin-top: 50px;">
          <div class="col-md-12 text-right">
            <button class="btn btn-primary create-btn">Create</button>
          </div>
          <div class="col-md-12 text-left">
            <h4 class="text-left">Hello <?= $logged_user['name']; ?></h4>
          </div>
          <div class="col-md-12">
            <h3 class="text-center">User details</h3>
          </div>
          <div class="col-md-3">
          </div>
          <div class="col-md-6">
          <table class="table table-striped table-bordered">
            <thead>
              <tr>
                <th scope="col">Name</th>
                <th scope="col">Email</th>
                <th scope="col">Phone</th>
                <th scope="col">Action</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach($users as $user){ ?>
              <tr>
                <td><?= $user['name']; ?></td>
                <td><?= $user['email']; ?></td>
                <td><?= $user['phone']; ?></td>
                <td><button class="btn btn-primary btn-sm btn-edit" data-toggle="modal" data-target="#editModal<?= $user['id']; ?>">Edit</button></td>
              </tr>
              <div class="modal fade" id="editModal<?= $user['id']; ?>" role="dialog">
                <div class="modal-dialog">
                  <div class="modal-content">
                    <div class="modal-header">
                      <button type="button" class="close" data-dismiss="modal">&times;</button>
                      <h4 class="modal-title">Edit data</h4>
                    </div>
                    <div class="modal-body">
                        <form  method="post" action="<?= base_url('welcome/edit/'.$user['id'].''); ?>">
                          <div class="form-outline mb-4">
                            <label class="form-label">Name</label>
                            <input type="text" name="name" class="form-control" value="<?= $user['name'] ?>" required />
                          </div><br>    
                          <div class="form-outline mb-4">
                            <label class="form-label">Email</label>
                            <input type="email" name="email" class="form-control" value="<?= $user['email'] ?>" required />
                          </div><br>
                          <div class="form-outline mb-4">
                            <label class="form-label">Phone</label>
                            <input type="number" name="phone" class="form-control" value="<?= $user['phone'] ?>"  minlength="10" required />
                          </div><br>
                          

                    </div>
                    <div class="modal-footer">
                      <button type="submit" class="btn btn-primary">Edit</button>
                      <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    </div>
                    
                    </form>
                  </div>
                </div>
              </div>
  
              </div>
              <?php } ?>
            </tbody>
          </table>
          </div>
          <div class="col-md-3">
          </div>
        </div>
      </div>

  <!--Create modal-->
<div class="modal fade" id="createModal" role="dialog">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <button type="button" class="close" data-dismiss="modal">&times;</button>
          <h4 class="modal-title">Add data</h4>
        </div>
        <div class="modal-body">
          <p id="error" class="text-danger"></p>
            <form  method="post" action="<?= base_url('welcome/save'); ?>" onsubmit="return validation();">
              <div class="form-outline mb-4">
                <label class="form-label" for="form2Example1">Name</label>
                <input type="text" name="name" id="name" class="form-control" required />
              </div><br>    
              <div class="form-outline mb-4">
                <label class="form-label" for="form2Example1">Email</label>
                <input type="email" name="email" id="email" class="form-control" required />
              </div><br>
              <div class="form-outline mb-4">
                <label class="form-label" for="form2Example2">Phone</label>
                <input type="number" name="phone" id="phone" class="form-control" required />
              </div><br>
              

        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Add</button>
          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
        </div>
        
        </form>
      </div>
      
    </div>
  </div>
  
</div>

  </body> 
</html>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
<script>
  $(".create-btn").click(function(){
    $("#createModal").modal();
  });
  function validation()
  {
    
    if($('#phone').val().length < 10)
    {
      $('#error').html('Phone length should be 10');
      return false;
    }
  }
</script>