<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Company extends CI_Controller {

	public function __construct()
    {
        parent::__construct();

        $this->isAdminLoggedIn();
    }

    public function isAdminLoggedIn(){
        if($this->session->userdata('usertype') !== 'admin')
        {
            redirect(base_url('dashboard'));
            exit;
        }
    }
	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	public function index()
    {
        $data['title'] = 'Company';
        $page = 'company/index';
        $this->header_and_footer($page, $data);
    }
	public function addCompany()
    {
        // if($_POST['company_name'])
		// {
			$array = array(
				'company_name' => $_POST['company_name'],
			);
			if($this->model->add('company',$array))
			{
				echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
			}
		// }
    }
	public function viewCompany()
    {
		$data['list'] = $this->model->getResultData('company',[]);
		$this->load->view('company/tb',$data);
    }
	public function editCompany()
    {
		$data = $this->model->getRowData('company',['id'=>$_POST['id']]);
		$response = array(
			'eid' => $_POST['id'],
			'company_name' => $data['company_name'],
		);
		echo json_encode($response);
    }
	public function updateCompany()
    {
        if(isset($_POST['id']))
		{
			$array = array(
				'company_name' => $_POST['company_name'],
			);
			if($this->model->edit('company',$array,['id'=>$_POST['id']]))
			{
				echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
			}
		}
    }
	//Product Subcategory
	//Product Category management
	public function productSubCategory()
    {
        $data['title'] = 'Product SubCategory';
		$data['product_categories'] = $this->model->getResultData('product_category',[]);
        $page = 'product_subcategory/index';
        $this->header_and_footer($page, $data);
    }
	public function addProductSubCategory()
    {
        if($_POST['category_name'])
		{
			$array = array(
				'category_id' => $_POST['category_id'],
				'category_name' => $_POST['category_name'],
			);
			if($this->product_model->addProductSubCategory($array))
			{
				echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
			}
		}
    }
	public function viewProductSubCategory()
    {
		$data['list'] = $this->product_model->getProductSubCategoryResultData();
		$this->load->view('product_subcategory/tb',$data);
    }
	public function editProductSubCategory()
    {
		$data = $this->model->getRowData('product_subcategory',['id'=>$_POST['id']]);
		$response = array(
			'eid' => $_POST['id'],
			'category_id' => $data['category_id'],
			'category_name' => $data['category_name'],
			'category_photo' => base_url('assets/uploads/'.$data['category_photo'].''),
		);
		echo json_encode($response);
    }
	public function updateProductSubCategory()
    {
        if(isset($_POST['id']))
		{
			$array = array(
				'category_id' => $_POST['category_id'],
				'category_name' => $_POST['category_name'],
			);
			if($this->product_model->updateProductSubCategory($array,$_POST['id']))
			{
				echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
			}
		}
    }
	
}
