<div class="page-body">
          <div class="container-fluid">
            <div class="page-title">
              <div class="row">
                <div class="col-6">
                  <h3><?= $title; ?></h3>
                </div>
              </div>
            </div>
          </div>
          <!-- Container-fluid starts-->
          <div class="container-fluid">
            <div class="row">
              <div class="col-sm-12">
                <div class="card">
                  <div class="card-header">
                  <div class="row">
                  <div class="col-sm-6">
                    <h5><?= $title; ?></h5>
                  </div>
                  <div class="col-sm-6 text-right">
                    <button class="btn btn-success rounded add-btn" type="button" data-bs-toggle="modal" data-bs-target="#addProductSubCategoryModal" data-bs-original-title="Add <?= $title; ?>"><i class="fa fa-plus"></i> Add <?= $title; ?></button>
                   </div>
                 </div>
                  </div>
                  <div class="card-body">
                    <div class="table-responsive" id="tb">
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <!-- Container-fluid Ends-->
        </div>
        <!-- Modal -->
        <div class="modal fade modal-bookmark" id="addProductSubCategoryModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add <?= $title; ?></h5>
                <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
                <form class="form-bookmark" id="add-product-sub-category-form">
                  <div class="row g-2">
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Product Category</label>
                      <select name="category_id" class="form-control" id="category_id" required>
                          <option value="">Select</option>
                          <?php foreach($product_categories as $category){ ?>
                            <option value="<?= $category['id']; ?>" required><?= $category['category_name']; ?></option>
                          <?php } ?>
                      </select>                   
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Category Name</label>
                      <input class="form-control" name="category_name" id="category_name" type="text" required>
                    </div>
                    <div class="mb-3 mt-0 col-md-12">
                      <label for="bm-title">Photo</label>
                      <input class="form-control" name="category_photo" id="category_photo" type="file">
                    </div>
                  </div>
                  <button class="btn btn-secondary" type="submit">Save</button>
                  <button class="btn btn-primary" type="button" data-bs-dismiss="modal">Cancel</button>
                </form>
              </div>
            </div>
          </div>
        </div>

        <!-- Modal -->
        <div class="modal fade modal-bookmark" id="editProductSubCategoryModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Edit Product Category</h5>
                <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
                <form class="form-bookmark" id="edit-product-sub-category-form">
                  <div class="row g-2">
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Product Category</label>
                      <select name="category_id" class="form-control" id="e_category_id" required>
                          <option value="">Select</option>
                          <?php foreach($product_categories as $category){ ?>
                            <option value="<?= $category['id']; ?>" required><?= $category['category_name']; ?></option>
                          <?php } ?>
                      </select>                   
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Category Name</label>
                      <input class="form-control" name="category_name" id="e_category_name" type="text" required>
                    </div>
                    <div class="mb-3 mt-0 col-md-12">
                      <label for="bm-title">Photo</label>
                      <input class="form-control" name="category_photo" id="e_category_photo" type="file" >
                      <img id="category_photoview" height="70" style="display:none;margin-top:20px">
                    </div>
                  </div>
                  <input type="hidden" name="id" id="eid">
                  <button class="btn btn-secondary" type="submit">Update</button>
                  <button class="btn btn-primary" type="button" data-bs-dismiss="modal">Cancel</button>
                </form>
              </div>
            </div>
          </div>
        </div>

<script>
$(document).ready(function(){
  $.ajax({
      url: "<?= base_url('product/viewProductSubCategory'); ?>",
      method: "POST",
      data: '',
      success:function(res){
          $('#tb').html(res);
      }
  });
});
$("#add-product-sub-category-form").submit(function(e){
  e.preventDefault();
  var formData = new FormData(this);
  $.ajax({
      url: "<?php echo base_url('product/addProductSubCategory'); ?>",
      method: "POST",
      data:  formData,
      cache: false,
      contentType: false,
      processData: false,
      dataType:'json',
      success:function(res){
        if(res.return)
        {
          $('#addProductSubCategoryModal').modal('toggle'); 
          $('#add-product-sub-category-form')[0].reset();
          $('#tb').load('<?= base_url('product/viewProductSubCategory'); ?>');
          toastr.success(res.msg);
        }
        else
        {
          toastr.error(res.msg);
        }
      }
  });
});
function editProductSubCategory(id)
{
  $.ajax({
      url: "<?php echo base_url('product/editProductSubCategory'); ?>",
      method: "POST",
      data: {
          id:id
      },
      dataType: 'json',
      success:function(res){
        $("#eid").val(res.eid);
        $("#e_category_id option[value='"+res.category_id+"']").attr("selected", "selected");
        $("#e_category_name").val(res.category_name);
        $("#category_photoview").css('display','block');
        $("#category_photoview").attr("src", ""+res.category_photo+"");
        $("#category_photoview").val(res.category_photo);
      }
  });
};
$("#edit-product-sub-category-form").submit(function(e){
  e.preventDefault();
  var formData = new FormData(this);
  $.ajax({
      url: "<?php echo base_url('product/updateProductSubCategory'); ?>",
      method: "POST",
      data:  formData,
      cache: false,
      contentType: false,
      processData: false,
      dataType:'json',
      success:function(res){
        if(res.return)
        {
          $('#editProductSubCategoryModal').modal('toggle'); 
          $('#tb').load('<?= base_url('product/viewProductSubCategory'); ?>');
          toastr.success(res.msg);
        }
        else
        {
          toastr.error(res.msg);
        }
      }
  });
});

</script>