<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require_once('vendor/autoload.php');
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
class Customer extends CI_Controller {

	public function __construct()
    {
        parent::__construct();

        // $this->isAdminLoggedIn();
    }


	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	public function primaryCustomer()
    {
        $data['title'] = 'Primary Customer';
		$data['countries'] = $this->model->getResultData('countries',[]);
        $page = 'primary_customer/index';
        $this->header_and_footer($page, $data);
    }
	public function addPrimaryCustomer()
    {
		// $countEmail = $this->model->countData('primary_customer',['customer_emailid'=>$_POST['customer_emailid']]);
		// if($countEmail > 0 )
		// {
		// 	echo json_encode(['return'=>false,'msg'=>'Email already exist']);
		// }
		// else
		// {
			// echo $_POST['form_type'];
			// die('a'); 
			if($_POST['form_type'] == 'mf')
			{  
					$array = array(
							'customer_name'  => $_POST['customer_name'],
							'address'  => $_POST['address'],
							'address2'  => $_POST['address2'],
							'address3'  => $_POST['address3'],
							'city'  => $_POST['city'],
							'state'  => $_POST['state'],
							'pincode'  => $_POST['pincode'],
							'divopt'  => $_POST['divopt'],
							'customer_mobileno'  => $_POST['customer_mobileno'],
							'customer_emailid'  => $_POST['customer_emailid'],
							'occupation'  => $_POST['occupation'],
							'birthdate'  => $_POST['birthdate'],
							'type'  => 'Mutual fund',
					
				);
			}
				
				else if($_POST['form_type'] == 'mi')					
				{ 
					$array = array(
						'customer_name'  => $_POST['customer_name'],
						'company_name'  => $_POST['company_name'],
						'model'  => $_POST['model'],
						'policy_number'  => $_POST['policy_number'],
						'provider'  => $_POST['provider'],
						'policy_type'  => $_POST['policy_type'],
						'sum_assured'  => $_POST['sum_assured'],
						'amount'  => $_POST['amount'],
						'birthdate' =>  $_POST['birthdate'],
						'address' => $_POST['address'],
						'address2' => $_POST['address2'],
						'address3' => $_POST['address3'],
						'city' => $_POST['city'],
						'state' => $_POST['state'],
						'pincode' => $_POST['pincode'],
						'divopt' => $_POST['divopt'],
						'customer_emailid' => $_POST['customer_emailid'],
						'customer_mobileno' =>  $_POST['customer_mobileno'],
						'occupation'  => $_POST['occupation'],
						'birthdate'  => $_POST['birthdate'],
						'policy_date_to'  => $_POST['policy_date_to'],
						'policy_date_till'  => $_POST['policy_date_till'],
						'type'  => 'Motor Insurance',

					);
				}
				else if($_POST['form_type'] == 'gi')
				   {
					$array = array(
						'customer_name'  => $_POST['customer_name'],
						'company_name'  => $_POST['company_name'],
						'model'  => $_POST['model'],
						'policy_number'  => $_POST['policy_number'],
						'provider'  => $_POST['provider'],
						'policy_type'  => $_POST['policy_type'],
						'sum_assured'  => $_POST['sum_assured'],
						'amount'  => $_POST['amount'],
						'birthdate' =>  $_POST['birthdate'],
						'address' => $_POST['address'],
						'address2' => $_POST['address2'],
						'address3' => $_POST['address3'],
						'city' => $_POST['city'],
						'state' => $_POST['state'],
						'pincode' => $_POST['pincode'],
						'divopt' => $_POST['divopt'],
						'customer_emailid' => $_POST['customer_emailid'],
						'customer_mobileno' =>  $_POST['customer_mobileno'],
						'occupation'  => $_POST['occupation'],
						'birthdate'  => $_POST['birthdate'],
						'policy_date_to'  => $_POST['policy_date_to'],
						'policy_date_till'  => $_POST['policy_date_till'],
						'type'  => 'General Insurance',

					);}
				else if($_POST['form_type'] == 'hdfc')
				   {
					$array = array(
						'customer_name'  => $_POST['customer_name'],
						'company_name'  => $_POST['company_name'],
						'model'  => $_POST['model'],
						'policy_number'  => $_POST['policy_number'],
						'provider'  => $_POST['provider'],
						'policy_type'  => $_POST['policy_type'],
						'sum_assured'  => $_POST['sum_assured'],
						'amount'  => $_POST['amount'],
						'birthdate' =>  $_POST['birthdate'],
						'address' => $_POST['address'],
						'address2' => $_POST['address2'],
						'address3' => $_POST['address3'],
						'city' => $_POST['city'],
						'state' => $_POST['state'],
						'pincode' => $_POST['pincode'],
						'divopt' => $_POST['divopt'],
						'customer_emailid' => $_POST['customer_emailid'],
						'customer_mobileno' =>  $_POST['customer_mobileno'],
						'occupation'  => $_POST['occupation'],
						'birthdate'  => $_POST['birthdate'],
						'policy_date_to'  => $_POST['policy_date_to'],
						'policy_date_till'  => $_POST['policy_date_till'],
						'type'  => 'Hdfc',

					);}
				else if($_POST['form_type'] == 'bajaj')
				   {
					$array = array(
						'customer_name'  => $_POST['customer_name'],
						'company_name'  => $_POST['company_name'],
						'model'  => $_POST['model'],
						'policy_number'  => $_POST['policy_number'],
						'provider'  => $_POST['provider'],
						'policy_type'  => $_POST['policy_type'],
						'sum_assured'  => $_POST['sum_assured'],
						'amount'  => $_POST['amount'],
						'birthdate' =>  $_POST['birthdate'],
						'address' => $_POST['address'],
						'address2' => $_POST['address2'],
						'address3' => $_POST['address3'],
						'city' => $_POST['city'],
						'state' => $_POST['state'],
						'pincode' => $_POST['pincode'],
						'divopt' => $_POST['divopt'],
						'customer_emailid' => $_POST['customer_emailid'],
						'customer_mobileno' =>  $_POST['customer_mobileno'],
						'occupation'  => $_POST['occupation'],
						'birthdate'  => $_POST['birthdate'],
						'policy_date_to'  => $_POST['policy_date_to'],
						'policy_date_till'  => $_POST['policy_date_till'],
						'type'  => 'Bajaj',

					);}
				else if($_POST['form_type'] == 'renewbuy')
				   {
					$array = array(
						'customer_name'  => $_POST['customer_name'],
						'company_name'  => $_POST['company_name'],
						'model'  => $_POST['model'],
						'policy_number'  => $_POST['policy_number'],
						'provider'  => $_POST['provider'],
						'policy_type'  => $_POST['policy_type'],
						'sum_assured'  => $_POST['sum_assured'],
						'amount'  => $_POST['amount'],
						'policy_date_to'  => $_POST['policy_date_to'],
						'policy_date_till'  => $_POST['policy_date_till'],
						'type'  => 'Renew Buy',

					);}
				else if($_POST['form_type'] == 'li')
				   {
					$array = array(
						'customer_name'  => $_POST['customer_name'],
						'company_name'  => $_POST['company_name'],
						'product_name'  => $_POST['product_name'],
						'policy_number'  => $_POST['policy_number'],
						'sum_assured'  => $_POST['sum_assured'],
						'amount'  => $_POST['amount'],
						'policy_date_to'  => $_POST['policy_date_to'],
						'policy_date_till'  => $_POST['policy_date_till'],
						'type'  => 'LI',

					);}
				else if($_POST['form_type'] == 'hdfcfd')
				   {
					$array = array(
						'customer_name'  => $_POST['customer_name'],
						'fd_number'  => $_POST['fd_number'],
						'customer_pan'  => $_POST['customer_pan'],
						'dep_amount'  => $_POST['dep_amount'],
						'tenure'  => $_POST['tenure'],
						'policy_date_to'  => $_POST['policy_date_to'],
						'policy_date_till'  => $_POST['policy_date_till'],
						'product_name'  => $_POST['product_name'],
						'client_id'  => $_POST['client_id'],
						'type'  => 'HDFC FD',

					);}
				else if($_POST['form_type'] == 'icicipli')
				   {
					$array = array(
						'policy_name'  => $_POST['policy_name'],
						'policy_number'  => $_POST['policy_number'],
						'risk_date'  => $_POST['risk_date'],
						'sum_assured'  => $_POST['sum_assured'],
						'premium_installment'  => $_POST['premium_installment'],
						// 'payment_frequency' =>  $_POST['payment_frequency'],
						'policy_term' => $_POST['policy_term'],
						'premium_paying' => $_POST['premium_paying'],
						'annual_premium' => $_POST['annual_premium'],
						'owner_name' => $_POST['owner_name'],
						'address' => $_POST['address'],
						'city' => $_POST['city'],
						'customer_emailid' => $_POST['customer_emailid'],
						'customer_mobileno' =>  $_POST['customer_mobileno'],
						'birthdate'  => $_POST['birthdate'],
						'premium_due' => $_POST['premium_due'],
						'policy_date_to'  => $_POST['policy_date_to'],
						'policy_date_till'  => $_POST['policy_date_till'],
						'address_status' => $_POST['address_status'],
						'payment_mode' => $_POST['payment_mode'],
						'type'  => 'ICICI PLI',

					);}
				else if($_POST['form_type'] == 'pnbfd')
				   {
					$array = array(
						'customer_name'  => $_POST['customer_name'],
						'FDR_number'  => $_POST['FDR_number'],
						'customer_pan'  => $_POST['customer_pan'],
						'dep_amount'  => $_POST['dep_amount'],
						'tenure'  => $_POST['tenure'],
						'policy_date_to'  => $_POST['policy_date_to'],
						'policy_date_till'  => $_POST['policy_date_till'],
						'product_name'  => $_POST['product_name'],
						'client_id'  => $_POST['client_id'],
						'type'  => 'PNB FD',

					);}
					else if($_POST['form_type'] == 'tan-service')
				   {
						$array = array(
							'customer_name'  => $_POST['customer_name'],
							'address'  => $_POST['address'],
							'policy_number'  => $_POST['policy_number'],
							'sa_in_lakh'  => $_POST['sa_in_lakh'],
							'plan_term'  => $_POST['plan_term'],
							'payment_mode'  => $_POST['payment_mode'],
							'risk_date'  => $_POST['risk_date'],
							'premium_amount'  => $_POST['premium_amount'],
							'birthdate'  => $_POST['birthdate'],
							'branch_code'  => $_POST['branch_code'],
							'type'  => 'tan-service',
						);
					}
					else if($_POST['form_type'] == 'rttr')
				   {
						$array = array(
							'customer_name'  => $_POST['customer_name'],
							'address'  => $_POST['address'],
							'policy_number'  => $_POST['policy_number'],
							'sa_in_lakh'  => $_POST['sa_in_lakh'],
							'plan_term'  => $_POST['plan_term'],
							'payment_mode'  => $_POST['payment_mode'],
							'risk_date'  => $_POST['risk_date'],
							'premium_amount'  => $_POST['premium_amount'],
							'birthdate'  => $_POST['birthdate'],
							'branch_code'  => $_POST['branch_code'],
							'type'  => 'rttr',
						);
					}
					if($this->model->add('primary_customer',$array))
					{
						echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
					}
			

				// if($this->customer_model->addPrimaryCustomer($array))
				// {
				// 	echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
				// }
			
			
		}
	
    
	public function viewPrimaryCustomer()
    {
		$type = null;$search = null;
		$where = [];

		if(isset($_POST['type']) && $_POST['type'] !== ''){
			$where = ['type'=>$_POST['type']];
		}
		if(isset($_POST['search']) && $_POST['search'] !== ''){
			$search = $_POST['search'];
		}
		//pagination
		$recordsPerPage = 10;
		$page = isset($_POST['page']) ? (int)$_POST['page'] : 1;
		$data['page'] = $page;
		$start = ($page > 1) ? ($page * $recordsPerPage) - $recordsPerPage : 0;
		// Get the total number of records from the database
		$total = count($this->customer_model->getPrimaryCustomerResultData($where,null,null,$search));
		// Calculate the total pages
		$totalPages = ceil($total / $recordsPerPage);
		$data['totalPages'] = $totalPages;

		$data['list'] = $this->customer_model->getPrimaryCustomerResultData($where,$recordsPerPage,$start,$search);
		$this->load->view('primary_customer/tb',$data);
    }
	public function editDocPrimaryCustomer()
    {
        $response=array();
		$data = $this->model->getRowData('primary_customer',['id' => $_POST['id']]);
		
		$response = array(
			'id' => $_POST['id'],
			'pancard' => base_url('assets/uploads/'.$data['pancard'].''),
			'aadhar' => base_url('assets/uploads/'.$data['aadhar'].''),
			'other1' => base_url('assets/uploads/'.$data['other1'].''),
			'other2' => base_url('assets/uploads/'.$data['other2'].''),
			'imp_doc1' => base_url('assets/uploads/'.$data['imp_doc1'].''),
			'imp_doc2' => base_url('assets/uploads/'.$data['imp_doc2'].''),
			'imp_doc3' => base_url('assets/uploads/'.$data['imp_doc3'].''),
			'imp_doc4' => base_url('assets/uploads/'.$data['imp_doc4'].''),
		);
		echo json_encode($response);
    }
	public function updateDocPrimaryCustomer()
    {
        if(isset($_POST['id']))
		{
			if($this->customer_model->updatePrimaryCustomer([],$_POST['id']))
			{
				echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
							 
			}
		}
    }
	public function editPrimaryCustomer()
    {
        $response=array();
		$data = $this->model->getRowData('primary_customer',['id' => $_POST['id']]);
		if($data['type'] == 'Mutual fund'){
			$response = array(
				'id' => $_POST['id'],
				'customer_name' => $data['customer_name'],
				'address'  => $data['address'],
				'address2'  => $data['address2'],
				'address3'  => $data['address3'],
				'city'  => $data['city'],
				'state'  => $data['state'],
				'pincode'  => $data['pincode'],
				'divopt'  => $data['divopt'],
				'customer_mobileno'  => $data['customer_mobileno'],
				'customer_emailid'  => $data['customer_emailid'],
				'occupation'  => $data['occupation'],
				'birthdate'  => $data['birthdate'],
				'type' => $data['type'],
				// 'customer_emailid' => $data['customer_emailid'],
				// 'customer_mobileno' =>  $data['customer_mobileno'],
				// 'birthdate' =>  $data['birthdate'],
				// 'anniversary_date' =>  $data['anniversary_date'],
				// 'address' => $data['address'],
				// 'country' => $data['country'],
				// 'state' => $data['state'],
				// 'city' => $data['city'],
				// 'pincode' => $data['pincode'],
				// 'pancard' => base_url('assets/uploads/'.$data['pancard'].''),
				// 'aadhar' => base_url('assets/uploads/'.$data['aadhar'].''),
				// 'other1' => base_url('assets/uploads/'.$data['other1'].''),
				// 'other2' => base_url('assets/uploads/'.$data['other2'].''),
				// 'imp_doc1' => base_url('assets/uploads/'.$data['imp_doc1'].''),
				// 'imp_doc2' => base_url('assets/uploads/'.$data['imp_doc2'].''),
				// 'imp_doc3' => base_url('assets/uploads/'.$data['imp_doc3'].''),
				// 'imp_doc4' => base_url('assets/uploads/'.$data['imp_doc4'].''),
			);
		}
			else if($data['type'] == 'Motor Insurance'){
				$response = array(
					'id' => $_POST['id'],
					'customer_name'  => $data['customer_name'],
						'company_name'  => $data['company_name'],
						'model'  => $data['model'],
						'policy_number'  => $data['policy_number'],
						'provider'  => $data['provider'],
						'policy_type'  => $data['policy_type'],
						'sum_assured'  => $data['sum_assured'],
						'amount'  => $data['amount'],
						'birthdate' =>  $data['birthdate'],
						'address' => $data['address'],
						'address2' => $data['address2'],
						'address3' => $data['address3'],
						'city' => $data['city'],
						'state' => $data['state'],
						'pincode' => $data['pincode'],
						'divopt' => $data['divopt'],
						'customer_emailid' => $data['customer_emailid'],
						'customer_mobileno' =>  $data['customer_mobileno'],
						'occupation'  => $data['occupation'],
						'birthdate'  => $data['birthdate'],
						'policy_date_to'  => $data['policy_date_to'],
						'policy_date_till'  => $data['policy_date_till'],
						'type' => $data['type'],
				);
			}
			else if($data['type'] == 'General Insurance'){
				$response = array(
					'id' => $_POST['id'],
					'customer_name'  => $data['customer_name'],
						'company_name'  => $data['company_name'],
						'model'  => $data['model'],
						'policy_number'  => $data['policy_number'],
						'provider'  => $data['provider'],
						'policy_type'  => $data['policy_type'],
						'sum_assured'  => $data['sum_assured'],
						'amount'  => $data['amount'],
						'birthdate' =>  $data['birthdate'],
						'address' => $data['address'],
						'address2' => $data['address2'],
						'address3' => $data['address3'],
						'city' => $data['city'],
						'state' => $data['state'],
						'pincode' => $data['pincode'],
						'divopt' => $data['divopt'],
						'customer_emailid' => $data['customer_emailid'],
						'customer_mobileno' =>  $data['customer_mobileno'],
						'occupation'  => $data['occupation'],
						'birthdate'  => $data['birthdate'],
						'policy_date_to'  => $data['policy_date_to'],
						'policy_date_till'  => $data['policy_date_till'],
						'type' => $data['type'],
				);
			}
			else if($data['type'] == 'Hdfc'){
				$response = array(
					'id' => $_POST['id'],
					'customer_name'  => $data['customer_name'],
						'company_name'  => $data['company_name'],
						'model'  => $data['model'],
						'policy_number'  => $data['policy_number'],
						'provider'  => $data['provider'],
						'policy_type'  => $data['policy_type'],
						'sum_assured'  => $data['sum_assured'],
						'amount'  => $data['amount'],
						'birthdate' =>  $data['birthdate'],
						'address' => $data['address'],
						'address2' => $data['address2'],
						'address3' => $data['address3'],
						'city' => $data['city'],
						'state' => $data['state'],
						'pincode' => $data['pincode'],
						'divopt' => $data['divopt'],
						'customer_emailid' => $data['customer_emailid'],
						'customer_mobileno' =>  $data['customer_mobileno'],
						'occupation'  => $data['occupation'],
						'birthdate'  => $data['birthdate'],
						'policy_date_to'  => $data['policy_date_to'],
						'policy_date_till'  => $data['policy_date_till'],
						'type' => $data['type'],
				);
			}
			else if($data['type'] == 'Bajaj'){
				$response = array(
					'id' => $_POST['id'],
					'customer_name'  => $data['customer_name'],
						'company_name'  => $data['company_name'],
						'model'  => $data['model'],
						'policy_number'  => $data['policy_number'],
						'provider'  => $data['provider'],
						'policy_type'  => $data['policy_type'],
						'sum_assured'  => $data['sum_assured'],
						'amount'  => $data['amount'],
						'birthdate' =>  $data['birthdate'],
						'address' => $data['address'],
						'address2' => $data['address2'],
						'address3' => $data['address3'],
						'city' => $data['city'],
						'state' => $data['state'],
						'pincode' => $data['pincode'],
						'divopt' => $data['divopt'],
						'customer_emailid' => $data['customer_emailid'],
						'customer_mobileno' =>  $data['customer_mobileno'],
						'occupation'  => $data['occupation'],
						'birthdate'  => $data['birthdate'],
						'policy_date_to'  => $data['policy_date_to'],
						'policy_date_till'  => $data['policy_date_till'],
						'type' => $data['type'],
				);
			}
			else if($data['type'] == 'Renew Buy'){
				$response = array(
					'id' => $_POST['id'],
						'customer_name'  => $data['customer_name'],
						'company_name'  => $data['company_name'],
						'model'  => $data['model'],
						'policy_number'  => $data['policy_number'],
						'provider'  => $data['provider'],
						'policy_type'  => $data['policy_type'],
						'sum_assured'  => $data['sum_assured'],
						'amount'  => $data['amount'],
						'policy_date_to'  => $data['policy_date_to'],
						'policy_date_till'  => $data['policy_date_till'],
						'type' => $data['type'],
				);
			}
			else if($data['type'] == 'LI'){
				$response = array(
					'id' => $_POST['id'],
						'customer_name'  => $data['customer_name'],
						'company_name'  => $data['company_name'],
						'product_name'  => $data['product_name'],
						'policy_number'  => $data['policy_number'],
						'sum_assured'  => $data['sum_assured'],
						'amount'  => $data['amount'],
						'policy_date_to'  => $data['policy_date_to'],
						'policy_date_till'  => $data['policy_date_till'],
						'type' => $data['type'],
				);
			}
			else if($data['type'] == 'HDFC FD'){
				// die('a');exit;
				$response = array(
						'id' => $_POST['id'],
						'customer_name'  => $data['customer_name'],
						'fd_number'  => $data['fd_number'],
						'customer_pan'  => $data['customer_pan'],
						'dep_amount'  => $data['dep_amount'],
						'tenure'  => $data['tenure'],
						'policy_date_to'  => $data['policy_date_to'],
						'policy_date_till'  => $data['policy_date_till'],
						'product_name'  => $data['product_name'],
						'client_id'  => $data['client_id'],
						'type' => $data['type'],
				);
			}
			else if($data['type'] == 'ICICI PLI'){
				$response = array(
						'id' => $_POST['id'],
						'policy_name'  => $data['policy_name'],
						'policy_number'  => $data['policy_number'],
						'risk_date'  => $data['risk_date'],
						'sum_assured'  => $data['sum_assured'],
						'premium_installment'  => $data['premium_installment'],
						// 'payment_frequency' =>  $data['payment_frequency'],
						'policy_term' => $data['policy_term'],
						'premium_paying' => $data['premium_paying'],
						'annual_premium' => $data['annual_premium'],
						'customer_name' => $data['customer_name'],
						'address' => $data['address'],
						'city' => $data['city'],
						'customer_emailid' => $data['customer_emailid'],
						'customer_mobileno' =>  $data['customer_mobileno'],
						'birthdate'  => $data['birthdate'],
						'premium_due' => $data['premium_due'],
						'policy_date_to'  => $data['policy_date_to'],
						'policy_date_till'  => $data['policy_date_till'],
						'address_status' => $data['address_status'],
						'payment_mode' => $data['payment_mode'],
						'type' => $data['type'],
				);
			}
			else if($data['type'] == 'tan-service'){
				$response = array(
						'id' => $_POST['id'],
						'customer_name'  => $data['customer_name'],
						'address'  => $data['address'],
						'policy_number'  => $data['policy_number'],
						'sa_in_lakh'  => $data['sa_in_lakh'],
						'plan_term'  => $data['plan_term'],
						'payment_mode'  => $data['payment_mode'],
						'risk_date'  => $data['risk_date'],
						'premium_amount'  => $data['premium_amount'],
						'birthdate'  => $data['birthdate'],
						'branch_code'  => $data['branch_code'],
						'type' => $data['type'],
				);
			}
			else if($data['type'] == 'rttr'){
				$response = array(
						'id' => $_POST['id'],
						'customer_name'  => $data['customer_name'],
						'address'  => $data['address'],
						'policy_number'  => $data['policy_number'],
						'sa_in_lakh'  => $data['sa_in_lakh'],
						'plan_term'  => $data['plan_term'],
						'payment_mode'  => $data['payment_mode'],
						'risk_date'  => $data['risk_date'],
						'premium_amount'  => $data['premium_amount'],
						'birthdate'  => $data['birthdate'],
						'branch_code'  => $data['branch_code'],
						'type' => $data['type'],
				);
			}
			else if($data['type'] == 'PNB FD'){
				$response = array(
						'id' => $_POST['id'],
						'customer_name'  => $data['customer_name'],
						'FDR_number'  => $data['FDR_number'],
						'customer_pan'  => $data['customer_pan'],
						'dep_amount'  => $data['dep_amount'],
						'tenure'  => $data['tenure'],
						'policy_date_to'  => $data['policy_date_to'],
						'policy_date_till'  => $data['policy_date_till'],
						'product_name'  => $data['product_name'],
						'client_id'  => $data['client_id'],
						'type'  => $data['type'],
				);
			}
				
		
		echo json_encode($response);
    }
	public function updatePrimaryCustomer()
    {
		
			// if(isset($_POST['id']))
			// {
			// 	$array = array(
			// 		'customer_name' => ucfirst($_POST['customer_name']),
			// 		'customer_emailid' => $_POST['customer_emailid'],
			// 		'customer_mobileno' =>  $_POST['customer_mobileno'],
			// 		'birthdate' =>  $_POST['birthdate'],
			// 		'anniversary_date' =>  $_POST['anniversary_date'],
			// 		'address' => $_POST['address'],
			// 		'country' => $_POST['country'],
			// 		'state' => $_POST['state'],
			// 		'city' => $_POST['city'],
			// 		'pincode' => $_POST['pincode'],
			// 	);
			if($_POST['form_type'] == 'mf')
			// if(isset($_POST['id']))
			{  
				// die('a');
					$array = array(
							'customer_name'  => $_POST['customer_name'],
							'address'  => $_POST['address'],
							'address2'  => $_POST['address2'],
							'address3'  => $_POST['address3'],
							'city'  => $_POST['city'],
							'state'  => $_POST['state'],
							'pincode'  => $_POST['pincode'],
							'divopt'  => $_POST['divopt'],
							'customer_mobileno'  => $_POST['customer_mobileno'],
							'customer_emailid'  => $_POST['customer_emailid'],
							'occupation'  => $_POST['occupation'],
							'birthdate'  => $_POST['birthdate'],
							'type'  => 'Mutual fund',
					
				);
			}
			else if($_POST['form_type'] == 'mi')					
				{ 
					$array = array(
						'customer_name'  => $_POST['customer_name'],
						'company_name'  => $_POST['company_name'],
						'model'  => $_POST['model'],
						'policy_number'  => $_POST['policy_number'],
						'provider'  => $_POST['provider'],
						'policy_type'  => $_POST['policy_type'],
						'sum_assured'  => $_POST['sum_assured'],
						'amount'  => $_POST['amount'],
						'birthdate' =>  $_POST['birthdate'],
						'address' => $_POST['address'],
						'address2' => $_POST['address2'],
						'address3' => $_POST['address3'],
						'city' => $_POST['city'],
						'state' => $_POST['state'],
						'pincode' => $_POST['pincode'],
						'divopt' => $_POST['divopt'],
						'customer_emailid' => $_POST['customer_emailid'],
						'customer_mobileno' =>  $_POST['customer_mobileno'],
						'occupation'  => $_POST['occupation'],
						'birthdate'  => $_POST['birthdate'],
						'policy_date_to'  => $_POST['policy_date_to'],
						'policy_date_till'  => $_POST['policy_date_till'],
						'type'  => 'Motor Insurance',

					);
				}
				else if($_POST['form_type'] == 'gi')
				{
					$array = array(
						'customer_name'  => $_POST['customer_name'],
						'company_name'  => $_POST['company_name'],
						'model'  => $_POST['model'],
						'policy_number'  => $_POST['policy_number'],
						'provider'  => $_POST['provider'],
						'policy_type'  => $_POST['policy_type'],
						'sum_assured'  => $_POST['sum_assured'],
						'amount'  => $_POST['amount'],
						'birthdate' =>  $_POST['birthdate'],
						'address' => $_POST['address'],
						'address2' => $_POST['address2'],
						'address3' => $_POST['address3'],
						'city' => $_POST['city'],
						'state' => $_POST['state'],
						'pincode' => $_POST['pincode'],
						'divopt' => $_POST['divopt'],
						'customer_emailid' => $_POST['customer_emailid'],
						'customer_mobileno' =>  $_POST['customer_mobileno'],
						'occupation'  => $_POST['occupation'],
						'birthdate'  => $_POST['birthdate'],
						'policy_date_to'  => $_POST['policy_date_to'],
						'policy_date_till'  => $_POST['policy_date_till'],
						'type'  => 'General Insurance',

					);
				}
				else if($_POST['form_type'] == 'hdfc')
				   {
					$array = array(
						'customer_name'  => $_POST['customer_name'],
						'company_name'  => $_POST['company_name'],
						'model'  => $_POST['model'],
						'policy_number'  => $_POST['policy_number'],
						'provider'  => $_POST['provider'],
						'policy_type'  => $_POST['policy_type'],
						'sum_assured'  => $_POST['sum_assured'],
						'amount'  => $_POST['amount'],
						'birthdate' =>  $_POST['birthdate'],
						'address' => $_POST['address'],
						'address2' => $_POST['address2'],
						'address3' => $_POST['address3'],
						'city' => $_POST['city'],
						'state' => $_POST['state'],
						'pincode' => $_POST['pincode'],
						'divopt' => $_POST['divopt'],
						'customer_emailid' => $_POST['customer_emailid'],
						'customer_mobileno' =>  $_POST['customer_mobileno'],
						'occupation'  => $_POST['occupation'],
						'birthdate'  => $_POST['birthdate'],
						'policy_date_to'  => $_POST['policy_date_to'],
						'policy_date_till'  => $_POST['policy_date_till'],
						'type'  => 'Hdfc',

					);}
				else if($_POST['form_type'] == 'bajaj')
				   {
					$array = array(
						'customer_name'  => $_POST['customer_name'],
						'company_name'  => $_POST['company_name'],
						'model'  => $_POST['model'],
						'policy_number'  => $_POST['policy_number'],
						'provider'  => $_POST['provider'],
						'policy_type'  => $_POST['policy_type'],
						'sum_assured'  => $_POST['sum_assured'],
						'amount'  => $_POST['amount'],
						'birthdate' =>  $_POST['birthdate'],
						'address' => $_POST['address'],
						'address2' => $_POST['address2'],
						'address3' => $_POST['address3'],
						'city' => $_POST['city'],
						'state' => $_POST['state'],
						'pincode' => $_POST['pincode'],
						'divopt' => $_POST['divopt'],
						'customer_emailid' => $_POST['customer_emailid'],
						'customer_mobileno' =>  $_POST['customer_mobileno'],
						'occupation'  => $_POST['occupation'],
						'birthdate'  => $_POST['birthdate'],
						'policy_date_to'  => $_POST['policy_date_to'],
						'policy_date_till'  => $_POST['policy_date_till'],
						'type'  => 'Bajaj',

					);}
				else if($_POST['form_type'] == 'renewbuy')
				   {
					$array = array(
						'customer_name'  => $_POST['customer_name'],
						'company_name'  => $_POST['company_name'],
						'model'  => $_POST['model'],
						'policy_number'  => $_POST['policy_number'],
						'provider'  => $_POST['provider'],
						'policy_type'  => $_POST['policy_type'],
						'sum_assured'  => $_POST['sum_assured'],
						'amount'  => $_POST['amount'],
						'policy_date_to'  => $_POST['policy_date_to'],
						'policy_date_till'  => $_POST['policy_date_till'],
						'type'  => 'Renew Buy',

					);}
				else if($_POST['form_type'] == 'li')
				   {
					$array = array(
						'customer_name'  => $_POST['customer_name'],
						'company_name'  => $_POST['company_name'],
						'product_name'  => $_POST['product_name'],
						'policy_number'  => $_POST['policy_number'],
						'sum_assured'  => $_POST['sum_assured'],
						'amount'  => $_POST['amount'],
						'policy_date_to'  => $_POST['policy_date_to'],
						'policy_date_till'  => $_POST['policy_date_till'],
						'type'  => 'LI',

					);}
				else if($_POST['form_type'] == 'hdfcfd')
				   {  
					// print_r($_POST['id']);
					$array = array(
						'customer_name'  => $_POST['customer_name'],
						'fd_number'  => $_POST['fd_number'],
						'customer_pan'  => $_POST['customer_pan'],
						'dep_amount'  => $_POST['dep_amount'],
						'tenure'  => $_POST['tenure'],
						'policy_date_to'  => $_POST['policy_date_to'],
						'policy_date_till'  => $_POST['policy_date_till'],
						'product_name'  => $_POST['product_name'],
						'client_id'  => $_POST['client_id'],
						'type'  => 'HDFC FD',

					);}
				else if($_POST['form_type'] == 'icicipli')
				   {
					$array = array(
						'policy_name'  => $_POST['policy_name'],
						'policy_number'  => $_POST['policy_number'],
						'risk_date'  => $_POST['risk_date'],
						'sum_assured'  => $_POST['sum_assured'],
						'premium_installment'  => $_POST['premium_installment'],
						// 'payment_frequency' =>  $_POST['payment_frequency'],
						'policy_term' => $_POST['policy_term'],
						'premium_paying' => $_POST['premium_paying'],
						'annual_premium' => $_POST['annual_premium'],
						'owner_name' => $_POST['owner_name'],
						'address' => $_POST['address'],
						'city' => $_POST['city'],
						'customer_emailid' => $_POST['customer_emailid'],
						'customer_mobileno' =>  $_POST['customer_mobileno'],
						'birthdate'  => $_POST['birthdate'],
						'premium_due' => $_POST['premium_due'],
						'policy_date_to'  => $_POST['policy_date_to'],
						'policy_date_till'  => $_POST['policy_date_till'],
						'address_status' => $_POST['address_status'],
						'payment_mode' => $_POST['payment_mode'],
						'type'  => 'ICICI PLI',

					);}
				else if($_POST['form_type'] == 'pnbfd')
				   {
					$array = array(
						'customer_name'  => $_POST['customer_name'],
						'FDR_number'  => $_POST['FDR_number'],
						'customer_pan'  => $_POST['customer_pan'],
						'dep_amount'  => $_POST['dep_amount'],
						'tenure'  => $_POST['tenure'],
						'policy_date_to'  => $_POST['policy_date_to'],
						'policy_date_till'  => $_POST['policy_date_till'],
						'product_name'  => $_POST['product_name'],
						'client_id'  => $_POST['client_id'],
						'type'  => 'PNB FD',

					);}
				else if($_POST['form_type'] == 'tan-service')
				   {
					$array = array(
						'customer_name'  => $_POST['customer_name'],
						'address'  => $_POST['address'],
						'policy_number'  => $_POST['policy_number'],
						'sa_in_lakh'  => $_POST['sa_in_lakh'],
						'plan_term'  => $_POST['plan_term'],
						'payment_mode'  => $_POST['payment_mode'],
						'risk_date'  => $_POST['risk_date'],
						'premium_amount'  => $_POST['premium_amount'],
						'birthdate'  => $_POST['birthdate'],
						'branch_code'  => $_POST['branch_code'],
						'type'  => 'tan-service',

					);}
				else if($_POST['form_type'] == 'rttr')
				   {
					$array = array(
						'customer_name'  => $_POST['customer_name'],
						'address'  => $_POST['address'],
						'policy_number'  => $_POST['policy_number'],
						'sa_in_lakh'  => $_POST['sa_in_lakh'],
						'plan_term'  => $_POST['plan_term'],
						'payment_mode'  => $_POST['payment_mode'],
						'risk_date'  => $_POST['risk_date'],
						'premium_amount'  => $_POST['premium_amount'],
						'birthdate'  => $_POST['birthdate'],
						'branch_code'  => $_POST['branch_code'],
						'type'  => 'rttr',

					);}
				if($this->model->edit('primary_customer',$array,['id' => $_POST['id']]))
				{
					// echo $this->db->last_query();
					echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
				}
				// if($this->customer_model->updatePrimaryCustomer($array,$_POST['id']))
				// {
				// 	echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
				// }
			
				else
			{
				echo json_encode(['return'=>false,'msg'=>'`id` is required']);
			}
		
    }
  
    public function primaryCustomerDetail()
    {
        $id=$this->uri->segment(2);
        $data['title'] = 'Primary Customer Detail';
		$data['data'] = $this->customer_model->getPrimaryCustomerRowData($id);
        $page = 'primary_customer/detail';
        $this->header_and_footer($page, $data);
    }


	//Family customer
	public function familyCustomer()
    {
        $data['title'] = 'Family Customer';
		$data['primary_customers'] = $this->model->getResultData('primary_customer',['is_suspended'=>0]);
		$data['countries'] = $this->model->getResultData('countries',[]);
        $page = 'family_customer/index';
        $this->header_and_footer($page, $data);
    }
	public function addFamilyCustomer()
    {
		// $countEmail = $this->model->countData('family_customer',['customer_emailid'=>$_POST['customer_emailid']]);
		// if($countEmail > 0 )
		// {
		// 	echo json_encode(['return'=>false,'msg'=>'Email already exist']);
		// }
		// else
		// {
			if($_POST['customer_name'])
			{
				$array = array(
					'primary_customer_id' => $_POST['primary_customer_id'],
					'customer_name' => ucfirst($_POST['customer_name']),
					'customer_emailid' => $_POST['customer_emailid'],
					'customer_mobileno' =>  $_POST['customer_mobileno'],
					'birthdate' =>  $_POST['birthdate'],
					'anniversary_date' =>  $_POST['anniversary_date'],
					'address' => $_POST['address'],
					'country' => $_POST['country'],
					'state' => $_POST['state'],
					'city' => $_POST['city'],
					'pincode' => $_POST['pincode'],
				);
				if($this->customer_model->addFamilyCustomer($array))
				{
					echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
				}
				
			}
		// }
    }
	public function viewFamilyCustomer()
    {
		$data['list'] = $this->model->getResultData('family_customer',[]);
		$this->load->view('family_customer/tb',$data);
    }
	public function editFamilyCustomer()
    {
        $response=array();
		$data = $this->model->getRowData('family_customer',['id' => $_POST['id']]);
		$response = array(
			'id' => $_POST['id'],
			'primary_customer_id' => $data['primary_customer'],
			'customer_name' => $data['customer_name'],
			'customer_emailid' => $data['customer_emailid'],
			'customer_mobileno' =>  $data['customer_mobileno'],
			'birthdate' =>  $data['birthdate'],
			'anniversary_date' =>  $data['anniversary_date'],
			'address' => $data['address'],
			'country' => $data['country'],
			'state' => $data['state'],
			'city' => $data['city'],
			'pincode' => $data['pincode'],
			'pancard' => base_url('assets/uploads/'.$data['pancard'].''),
			'aadhar' => base_url('assets/uploads/'.$data['aadhar'].''),
			'other1' => base_url('assets/uploads/'.$data['other1'].''),
			'other2' => base_url('assets/uploads/'.$data['other2'].''),
			'imp_doc1' => base_url('assets/uploads/'.$data['imp_doc1'].''),
			'imp_doc2' => base_url('assets/uploads/'.$data['imp_doc2'].''),
			'imp_doc3' => base_url('assets/uploads/'.$data['imp_doc3'].''),
			'imp_doc4' => base_url('assets/uploads/'.$data['imp_doc4'].''),
		);
		echo json_encode($response);
    }
	public function updateFamilyCustomer()
    {
		// $countEmail = $this->model->countData('family_customer',['customer_emailid'=>$_POST['customer_emailid'],'id!='=>$_POST['id']]);
		// if($countEmail > 0 )
		// {
		// 	echo json_encode(['return'=>false,'msg'=>'Email already exist']);
		// }
		// else
		// {
			if(isset($_POST['id']))
			{
				$state = (isset($_POST['state'])?$_POST['state']:'');
				$city = (isset($_POST['city'])?$_POST['city']:'');
				$array = array(
					'primary_customer' => $_POST['primary_customer_id'],
					'customer_name' => ucfirst($_POST['customer_name']),
					'customer_emailid' => $_POST['customer_emailid'],
					'customer_mobileno' =>  $_POST['customer_mobileno'],
					'birthdate' =>  $_POST['birthdate'],
					'anniversary_date' =>  $_POST['anniversary_date'],
					'address' => $_POST['address'],
					'country' => $_POST['country'],
					'state' => $state,
					'city' => $city,
					'pincode' => $_POST['pincode'],
				);
				if($this->customer_model->updateFamilyCustomer($array,$_POST['id']))
				{
					echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
				}
			}
			else
			{
				echo json_encode(['return'=>false,'msg'=>'`id` is required']);
			}
		// }
    }
  
    public function familyCustomerDetail()
    {
        $id=$this->uri->segment(2);
        $data['title'] = 'Family Customer Detail';
		$data['data'] = $this->customer_model->getFamilyCustomerRowData($id);
        $page = 'family_customer/detail';
        $this->header_and_footer($page, $data);
    }	
	public function importPrimaryCustomer()
    {
        if(isset($_FILES["file"]["name"]))
		{
			$path = $_FILES["file"]["tmp_name"];
			$object = PHPExcel_IOFactory::load($path);
			$mobileArr = array();
			$allMobile = $this->model->getResultData('primary_customer',[]);
			foreach($allMobile as $all)
			{
				array_push($mobileArr,$all['customer_mobileno']);

			}
			// foreach($object->getWorksheetIterator() as $worksheet)
			// {
				$worksheet = $object->getActiveSheet();
				$highestRow = $worksheet->getHighestRow();
				$highestColumn = $worksheet->getHighestColumn();
				for($row=2; $row<=$highestRow; $row++)
				{
					$customer_name = $worksheet->getCellByColumnAndRow(1, $row)->getValue();
					$birthdate = $worksheet->getCellByColumnAndRow(2, $row)->getValue();
					$customer_mobileno = $worksheet->getCellByColumnAndRow(3, $row)->getValue();
					$customer_emailid = $worksheet->getCellByColumnAndRow(4, $row)->getValue();
					$address = $worksheet->getCellByColumnAndRow(5, $row)->getValue();
				// 	if (!in_array($customer_mobileno, $mobileArr))
				// 	{
						$data[] = array(
							'customer_name'  => $customer_name,
							'birthdate'  => $birthdate,
							'customer_mobileno'  => $customer_mobileno,
							'customer_emailid'  => $customer_emailid,
							'address'  => $address,
						);
				// 	}
				// 	else
				// 	{
				// 		$data[] = array();
				// 	}
				}
			// }
			if(!empty($data))
			{
			    $this->db->insert_batch('primary_customer', $data);
			}
			$this->viewPrimaryCustomer();
		}
    }
	public function importFamilyCustomer()
    {
        if(isset($_FILES["file"]["name"]))
		{
			$path = $_FILES["file"]["tmp_name"];
			$object = PHPExcel_IOFactory::load($path);
			$mobileArr = array();
			$pcusArr = array();
			$allMobile = $this->model->getResultData('family_customer',[]);
			$primaryCustomers = $this->model->getResultData('primary_customer',['is_suspended'=>0]);
			foreach($allMobile as $all)
			{
				array_push($mobileArr,$all['customer_mobileno']);

			}
			foreach($primaryCustomers as $pcus)
			{
				array_push($pcusArr,$pcus['id']);

			}
			foreach($object->getWorksheetIterator() as $worksheet)
			{
				$highestRow = $worksheet->getHighestRow();
				$highestColumn = $worksheet->getHighestColumn();
				for($row=2; $row<=$highestRow; $row++)
				{
					$customer_name = $worksheet->getCellByColumnAndRow(1, $row)->getValue();
					$birthdate = $worksheet->getCellByColumnAndRow(2, $row)->getValue();
					$customer_mobileno = $worksheet->getCellByColumnAndRow(3, $row)->getValue();
					$customer_emailid = $worksheet->getCellByColumnAndRow(4, $row)->getValue();
					$address = $worksheet->getCellByColumnAndRow(5, $row)->getValue();
					$primary_customer_id = $worksheet->getCellByColumnAndRow(6, $row)->getValue();
					if (in_array($primary_customer_id, $pcusArr))
					{
						$data[] = array(
							'primary_customer_id'  => $primary_customer_id,
							'customer_name'  => $customer_name,
							'birthdate'  => $birthdate,
							'customer_mobileno'  => $customer_mobileno,
							'customer_emailid'  => $customer_emailid,
							'address'  => $address,
						);
					}
				// 	else
				// 	{
				// 		$data[] = array();
				// 	}
				}
			}
			if(!empty($data))
			{
			    $this->db->insert_batch('family_customer', $data);
			}
			$this->viewFamilyCustomer();
		}
    }

	//Import customers
	public function customer()
    {
        $data['title'] = 'Customer';
		$data['customers'] = $this->model->getResultData('customers',[]);
        $page = 'customer/index';
        $this->header_and_footer($page, $data);
    }
	public function viewCustomer()
    {
		$data['list'] = $this->model->getResultData('customers',[]);
		$this->load->view('customer/tb',$data);
    }
  
	public function importCustomer()
    {
        if(isset($_FILES["file"]["name"]))
		{
			$path = $_FILES["file"]["tmp_name"];
			$object = PHPExcel_IOFactory::load($path);
			foreach($object->getWorksheetIterator() as $worksheet)
			{
				$highestRow = $worksheet->getHighestRow();
				$highestColumn = $worksheet->getHighestColumn();
				for($row=2; $row<=$highestRow; $row++)
				{
					$sno = $worksheet->getCellByColumnAndRow(1, $row)->getValue();
					echo $sno;
					// $customer_name = $worksheet->getCellByColumnAndRow(1, $row)->getValue();
					// $birthdate = $worksheet->getCellByColumnAndRow(2, $row)->getValue();
					// $customer_mobileno = $worksheet->getCellByColumnAndRow(3, $row)->getValue();
					// $customer_emailid = $worksheet->getCellByColumnAndRow(4, $row)->getValue();
					// $address = $worksheet->getCellByColumnAndRow(5, $row)->getValue();
					// $primary_customer_id = $worksheet->getCellByColumnAndRow(6, $row)->getValue();
					// $data[] = array(
					// 	'primary_customer_id'  => $primary_customer_id,
					// 	'customer_name'  => $customer_name,
					// 	'birthdate'  => $birthdate,
					// 	'customer_mobileno'  => $customer_mobileno,
					// 	'customer_emailid'  => $customer_emailid,
					// 	'address'  => $address,
					// );
				}
die('A');
			}
			if(!empty($data))
			{
			    $this->db->insert_batch('family_customer', $data);
			}
			$this->viewFamilyCustomer();
		}
    }
	//Grouped primary customer
	public function groupedPrimaryCustomer()
    {
        $data['title'] = 'Grouped Primary Customer';
        $page = 'grouped_primary_customer/index';
        $this->header_and_footer($page, $data);
    }
	// public function viewGroupedPrimaryCustomer()
    // {
	// 	$type = null;$data['type'] = null;$search = null;
	// 	$where = [];

	// 	if(isset($_POST['type']) && $_POST['type'] !== ''){
	// 		$where = ['type'=>$_POST['type']];
	// 	}
	// 	if(isset($_POST['search']) && $_POST['search'] !== ''){
	// 		$search = $_POST['search'];
	// 	}
	// 	//pagination
	// 	$recordsPerPage = 10;
	// 	$page = isset($_POST['page']) ? (int)$_POST['page'] : 1;
	// 	$data['page'] = $page;
	// 	$start = ($page > 1) ? ($page * $recordsPerPage) - $recordsPerPage : 0;
	// 	// Get the total number of records from the database
	// 	$pCustomerList = $this->customer_model->getGroupedPrimaryCustomerResultData($where,null,null,$search);
	
	// 	$Presult= array();$Pdata= array();
	// 		$c=0;foreach($pCustomerList as $val){$c++;
	// 			if(!in_array(strtolower($val['customer_name']),array_map("strtolower",$Presult))){
	// 				array_push($Presult,$val['customer_name']);
	// 				$Pdata['customer_name'] = $val['customer_name'];
	// 				array_push($Presult,$c);
	// 				$Presult[$c]= $Pdata;
	// 				// $Presult[$c] = array();
	// 				// $Pdata['customer_name'] = $val['customer_name'];
	// 				// array_merge($Presult,$Pdata);
	// 				// $Presult = array_merge($Presult, array("cat"=>"wagon","foo"=>"baar"));
	// 				// $Presult[$c] = $val['customer_name'];
	// 			}		
	// 		}
	// 		print_r($Presult);die();
	// 		// $aa = $this->customer_model->getPData($Presult);
	// 		$i=0;foreach($Presult as $customer_name){
				
	// 				$customerData = $this->model->getRowData('primary_customer',['customer_name'=>$customer_name],null,'id','desc');
			
	// 			if($customerData){
	// 				$customerId = $customerData['id'];
	// 				$customerDataa = $this->customer_model->getGroupedPrimaryCustomerRowData(['t1.id'=>$customerId],null,'t1.id','desc');
	// 				$Presult[$i++] = $customerDataa;
	// 			}
				
	// 		}
	// 		$data['list'] = $Presult;
	// 		print_r($data['list']);
	// 		die('A');
	// 	// $total = count($Presult);
	// 	// // Calculate the total pages
	// 	// $totalPages = ceil($total / $recordsPerPage);
	// 	// $data['totalPages'] = $totalPages;
	// 	// // end pagination


	// 	// $pCustList = $this->customer_model->getGroupedPrimaryCustomerResultData($where,$recordsPerPage,$start,$search);
	// 	// 	$result= array();
	// 	// 	foreach($pCustList as $val){
	// 	// 		// if(!in_array(strtolower($val['customer_emailid']),array_map("strtolower", $result))){
	// 	// 		// 	array_push($result,$val['customer_emailid']);
	// 	// 		// }
	// 	// 		if(!in_array($val['customer_name'],$result)){
	// 	// 			array_push($result,$val['customer_name']);
	// 	// 		}		
	// 	// 	}
	// 	// 	$i=0;foreach($result as $customer_name){
	// 	// 		// if(isset($_POST['type']) && $_POST['type'] !== ''){
	// 	// 		// 	$customerData = $this->model->getRowData('primary_customer',['customer_emailid'=>$customer_emailid,'type'=>$_POST['type']],null,'id','desc');
	// 	// 		// }else{
	// 	// 		$customerData = $this->model->getRowData('primary_customer',['customer_name'=>$customer_name],null,'id','desc');
	// 	// 		// }
	// 	// 		if($customerData){
	// 	// 			$customerId = $customerData['id'];
	// 	// 			$customerDataa = $this->customer_model->getGroupedPrimaryCustomerRowData(['t1.id'=>$customerId],null,'t1.id','desc');
	// 	// 			// $customerData = $this->customer_model->getPrimaryCustomerRowData($customerId);
	// 	// 			$result[$i++] = $customerDataa;
	// 	// 		}
				
	// 	// 	}
	// 	// 	$data['list'] = $result;
	// 	// 	// print_r($data['list']);die();
	// 	$this->load->view('grouped_primary_customer/tb',$data);
    // }
	public function viewGroupedPrimaryCustomer()
    {
		$type = 'null';$data['type'] = 'null';$search = 'null';$data['search'] = 'null';
		$where = [];

		if(isset($_POST['type']) && $_POST['type'] !== ''){
			$where = ['type'=>$_POST['type']];
			$data['type'] = $_POST['type'];
		}
		if(isset($_POST['search']) && $_POST['search'] !== ''){
			$search = $_POST['search'];
			$data['search'] = $_POST['search'];
		}
		//pagination
		$recordsPerPage = 10;
		$page = isset($_POST['page']) ? (int)$_POST['page'] : 1;
		$data['page'] = $page;
		$start = ($page > 1) ? ($page * $recordsPerPage) - $recordsPerPage : 0;
		// Get the total number of records from the database
		$total = count($this->customer_model->getGroupedPrimaryCustomerResultData($where,'null','null',$search));
		// Calculate the total pages
		$totalPages = ceil($total / $recordsPerPage);
		$data['totalPages'] = $totalPages;

		$data['list'] = $this->customer_model->getGroupedPrimaryCustomerResultData($where,$recordsPerPage,$start,$search);
	
	
		$this->load->view('grouped_primary_customer/tb',$data);
    }

	public function groupedPrimaryCustomerList()
    {
		$customer_name = $this->uri->segment(2);
		$customer_name = str_replace('%20', ' ', $customer_name);
		$data['title'] = 'List of '.$customer_name.'';
		$where = ['customer_name'=>$customer_name];
		$data['list'] = $this->model->getResultData('primary_customer',$where);
		$page = 'grouped_primary_customer/list';
        $this->header_and_footer($page, $data);
    }
	//Grouped family customer
	public function groupedFamilyCustomer()
    {
        $data['title'] = 'Grouped Family Customer';
		$data['primary_customers'] = $this->model->getResultData('primary_customer',['is_suspended'=>0]);
        $page = 'grouped_family_customer/index';
        $this->header_and_footer($page, $data);
    }
	// public function viewGroupedFamilyCustomer()
    // {
	// 	// $type = null;$data['type'] = null;
	// 	$search = null;
	// 	$where = [];

	// 	// if(isset($_POST['type']) && $_POST['type'] !== ''){
	// 	// 	$where = ['t2.type'=>$_POST['type']];
	// 	// 	$data['type'] = $_POST['type'];
	// 	// }
	// 	if(isset($_POST['search']) && $_POST['search'] !== ''){
	// 		$search = $_POST['search'];
	// 	}
	// 	//pagination
	// 	$recordsPerPage = 20;
	// 	$page = isset($_POST['page']) ? (int)$_POST['page'] : 1;
	// 	$data['page'] = $page;
	// 	$start = ($page > 1) ? ($page * $recordsPerPage) - $recordsPerPage : 0;
	// 	// Get the total number of records from the database
	// 	$fCustList = $this->customer_model->getGroupedFamilyCustomerResultData($where,null,null,$search);
	// 	// echo $this->db->last_query();
	// 	// die();
	// 	$Fresult= array();
	// 		foreach($fCustList as $val){
	// 			if(!in_array(strtolower($val['customer_name']),array_map("strtolower", $Fresult))){
	// 				array_push($Fresult,$val['customer_name']);
	// 			}		
	// 		}
	// 		$i=0;foreach($Fresult as $customer_name){
				
	// 				$customerData = $this->model->getRowData('family_customer',['customer_name'=>$customer_name],null,'id','desc');
			
	// 			if($customerData){
	// 				$customerId = $customerData['id'];
	// 				$customerData = $this->model->getRowData('family_customer',['id'=>$customerId]);
	// 				$Fresult[$i++] = $customerData;
	// 			}
				
	// 		}
	// 	$total = count($Fresult);
	// 	// Calculate the total pages
	// 	$totalPages = ceil($total / $recordsPerPage);
	// 	$data['totalPages'] = $totalPages;
	// 	// end pagination

	// 	$pCustList = $this->customer_model->getGroupedFamilyCustomerResultData($where,$recordsPerPage,$start,$search);
	// 		$result= array();
	// 		foreach($pCustList as $val){
	// 			if(!in_array(strtolower($val['customer_name']),array_map("strtolower", $result))){
	// 			// if(!in_array($val['customer_name'],$result)){
	// 				// array_push($result,strtolower($val['customer_name']));
	// 				array_push($result,$val['customer_name']);
	// 			}		
	// 		}
	// 		// echo '<pre>';print_r($result);die();
	// 		$i=0;foreach($result as $customer_name){
				
	// 				$customerData = $this->model->getRowData('family_customer',['customer_name'=>$customer_name],null,'id','desc');
	// 				// $customerData = $this->customer_model->getGroupedFamilyCustomerRowData(['t1.customer_emailid'=>$customer_emailid],null,'t1.id','desc');
			
	// 			if($customerData){
	// 				$customerId = $customerData['id'];
	// 				// $customerData = $this->model->getRowData('family_customer',['id'=>$customerId]);
	// 				$customerDataa = $this->customer_model->getGroupedFamilyCustomerRowData(['t1.id'=>$customerId],null,'t1.id','desc');
	// 				$result[$i++] = $customerDataa;
	// 			}
				
	// 		}
	// 		$data['list'] = $result;
			
	// 	$this->load->view('grouped_family_customer/tb',$data);
    // }
	public function viewGroupedFamilyCustomer()
    {
		$search = null;
		$where = [];

		if(isset($_POST['search']) && $_POST['search'] !== ''){
			$search = $_POST['search'];
		}
		//pagination
		$recordsPerPage = 10;
		$page = isset($_POST['page']) ? (int)$_POST['page'] : 1;
		$data['page'] = $page;
		$start = ($page > 1) ? ($page * $recordsPerPage) - $recordsPerPage : 0;
		// Get the total number of records from the database
		$total = count($this->customer_model->getGroupedFamilyCustomerResultData($where,null,null,$search));
		// Calculate the total pages
		$totalPages = ceil($total / $recordsPerPage);
		$data['totalPages'] = $totalPages;

		$data['list'] = $this->customer_model->getGroupedFamilyCustomerResultData($where,$recordsPerPage,$start,$search);
			
			
		$this->load->view('grouped_family_customer/tb',$data);
    }
	public function groupedFamilyCustomerList()
    {
		$customer_name = $this->uri->segment(2);
		$customer_name = str_replace('%20', ' ', $customer_name);
		$data['title'] = 'List of '.$customer_name.'';
		$where = ['customer_name'=>$customer_name];
		$data['list'] = $this->model->getResultData('family_customer',$where);
		$page = 'grouped_family_customer/list';
        $this->header_and_footer($page, $data);
    }
	public function array_insert(&$array, $value, $index)
	{
		return $array = array_merge(array_splice($array, max(0, $index - 1)), array($value), $array);
	}

	//excel export
	public function primaryCustomerExportToExcel()
    {
        ini_set('memory_limit', '-1');
		$spreadsheet = new Spreadsheet();
		$sheet = $spreadsheet->getActiveSheet();       

		$type = str_replace('%20', ' ', $this->uri->segment(3));
		// $search = str_replace('%20', ' ', $this->uri->segment(4));
		if($type!=='null'){
			$where = ['t1.type'=>$type];
		}else{
			$where = 'null';
		}
		
		
		$result = $this->customer_model->getGroupedPrimaryCustomerResultData($where,'null','null','null');
		$this->primaryCustomerExport($result,$spreadsheet,$sheet);


		$writer = new Xlsx($spreadsheet);
		$filename = 'Primary Customers';
		header('Content-Type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="'. $filename .'.xls"');
		header('Cache-Control: max-age=0');
		$writer->save('php://output'); // download file
    }
	public function primaryCustomerExport($result,$spreadsheet,$sheet){
			$sheet->setCellValue('A1', 'S.No.');
			$sheet->setCellValue('B1', 'Name');
			$sheet->setCellValue('C1', 'Type');
			$sheet->setCellValue('D1', 'Email');
			$sheet->setCellValue('E1', 'Mobile');
			$sheet->setCellValue('F1', 'Birthdate');
			$sheet->setCellValue('G1', 'Anniversary date');
			$sheet->setCellValue('H1', 'Country');
			$sheet->setCellValue('I1', 'State');
			$sheet->setCellValue('J1', 'City');
			$sheet->setCellValue('K1', 'Address');
			$sheet->setCellValue('L1', 'Address 2');
			$sheet->setCellValue('M1', 'Address 3');
			$sheet->setCellValue('N1', 'Pincode');
			$sheet->setCellValue('O1', 'Divopt');
			$sheet->setCellValue('P1', 'Occupation');
			$sheet->setCellValue('Q1', 'Policy date to');
			$sheet->setCellValue('R1', 'Policy date till');
			$sheet->setCellValue('S1', 'Model');
			$sheet->setCellValue('T1', 'Policy number');
			$sheet->setCellValue('U1', 'Company name');
			$sheet->setCellValue('V1', 'Provider');
			$sheet->setCellValue('W1', 'Policy type');
			$sheet->setCellValue('X1', 'Sum asssured');
			$sheet->setCellValue('Y1', 'Amount');
			$sheet->setCellValue('Z1', 'Product name');
			$sheet->setCellValue('AA1', 'FD number');
			$sheet->setCellValue('AB1', 'Customer Pan');
			$sheet->setCellValue('AC1', 'Deposit Amount');
			$sheet->setCellValue('AD1', 'Tenure');
			$sheet->setCellValue('AE1', 'Client ID');
			$sheet->setCellValue('AF1', 'Policy Name');
			$sheet->setCellValue('AG1', 'Risk Commencement');
			$sheet->setCellValue('AH1', 'Premium Installment');
			$sheet->setCellValue('AI1', 'Policy Term');
			$sheet->setCellValue('AJ1', 'Premium Paying');
			$sheet->setCellValue('AK1', 'Annual Premium');
			$sheet->setCellValue('AL1', 'Premium Due');
			$sheet->setCellValue('AM1', 'Address Status');
			$sheet->setCellValue('AN1', 'Payment Mode');
			$sheet->setCellValue('AO1', 'FDR Number');
			$sheet->setCellValue('AP1', 'Created');
			$count = 2;
			foreach($result as $value){
				if(isset($type)){
					$ftype = $type;
				}else{
					$ftype = $value['type'];
				}
				if($ftype == 'rttr'){
					$ftype = 'LIC';
				}else if($ftype == 'tan-service'){
					$ftype = 'LIC Service';
				}else{
					$ftype = $ftype;
				}
				if($value['birthdate']){$birthdate = date('d-m-Y',strtotime($value['birthdate']));}else{$birthdate = '';}
				if($value['anniversary_date']!=='0000-00-00'){$anniversary_date = date('d-m-Y',strtotime($value['anniversary_date']));}else{$anniversary_date = '';}
				$countCustomerByName = $this->model->countData('primary_customer',['customer_name'=>$value['customer_name']]);
				if($value['customer_name']!==NULL && $value['customer_name']!==''){

				$sheet->setCellValue('A'.$count, $value['id']);
				$sheet->setCellValue('B'.$count, $value['customer_name']);
				$sheet->setCellValue('C'.$count, $ftype);
				$sheet->setCellValue('D'.$count, $value['customer_emailid']);
				$sheet->setCellValue('E'.$count, $value['customer_mobileno']);
				$sheet->setCellValue('F'.$count, $birthdate);
				$sheet->setCellValue('G'.$count, $anniversary_date);
				$sheet->setCellValue('H'.$count, ($value['country_name'])?$value['country_name']:'');
				$sheet->setCellValue('I'.$count, ($value['state_name'])?$value['state_name']:'');
				$sheet->setCellValue('J'.$count, ($value['city_name'])?$value['city_name']:'');
				$sheet->setCellValue('K'.$count, $value['address']);
				$sheet->setCellValue('L'.$count, $value['address2']);
				$sheet->setCellValue('M'.$count, $value['address3']);
				$sheet->setCellValue('N'.$count, $value['pincode']);
				$sheet->setCellValue('O'.$count, $value['divopt']);
				$sheet->setCellValue('P'.$count, $value['occupation']);
				$sheet->setCellValue('Q'.$count, $value['policy_date_to']);
				$sheet->setCellValue('R'.$count, $value['policy_date_till']);
				$sheet->setCellValue('S'.$count, $value['model']);
				$sheet->setCellValue('T'.$count, $value['policy_number']);
				$sheet->setCellValue('U'.$count, $value['company_name']);
				$sheet->setCellValue('V'.$count, $value['provider']);
				$sheet->setCellValue('W'.$count, $value['policy_type']);
				$sheet->setCellValue('X'.$count, $value['sum_assured']);
				$sheet->setCellValue('Y'.$count, $value['amount']);
				$sheet->setCellValue('Z'.$count, $value['product_name']);
				$sheet->setCellValue('AA'.$count, $value['fd_number']);
				$sheet->setCellValue('AB'.$count, $value['customer_pan']);
				$sheet->setCellValue('AC'.$count, $value['dep_amount']);
				$sheet->setCellValue('AD'.$count, $value['tenure']);
				$sheet->setCellValue('AE'.$count, $value['client_id']);
				$sheet->setCellValue('AF'.$count, $value['policy_name']);
				$sheet->setCellValue('AG'.$count, $value['risk_commencement']);
				$sheet->setCellValue('AH'.$count, $value['premium_installment']);
				$sheet->setCellValue('AI'.$count, $value['policy_term']);
				$sheet->setCellValue('AJ'.$count, $value['premium_paying']);
				$sheet->setCellValue('AK'.$count, $value['annual_premium']);
				$sheet->setCellValue('AL'.$count, $value['premium_due']);
				$sheet->setCellValue('AM'.$count, $value['address_status']);
				$sheet->setCellValue('AN'.$count, $value['payment_mode']);
				$sheet->setCellValue('AO'.$count, $value['FDR_number']);
				$sheet->setCellValue('AP'.$count, date('d-m-Y',strtotime($value['created'])));
				$count++;
				}
				
			}
		
	}
}
